/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss;

import java.io.File;
import org.hyperic.hq.plugin.jboss.JBossDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;

public class JBossProductPlugin
extends ProductPlugin {
    private static boolean ignoreHashCodes = false;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        ignoreHashCodes = "true".equals(manager.getProperty("jboss.ignoreHashCodes"));
    }

    protected void adjustClassPath(String installpath) {
        File servers = new File(installpath, "server");
        if (!servers.exists()) {
            return;
        }
        File[] dirs = servers.listFiles();
        if (dirs == null) {
            return;
        }
        for (int i = 0; i < dirs.length; ++i) {
            File dir = dirs[i];
            String name = dir.getName();
            if (name.equals("all") || name.equals("default") || name.equals("minimal")) continue;
            super.adjustClassPath(dir.toString());
        }
    }

    public static boolean ignoreHashCodes() {
        return ignoreHashCodes;
    }

    public String[] getClassPath(ProductPluginManager manager) {
        String from;
        String prop = this.getName() + "." + "installpath";
        String sysval = System.getProperty(prop);
        String installDir = manager.getProperties().getProperty(prop, sysval);
        if (installDir == null) {
            installDir = JBossDetector.getRunningInstallPath((GenericPlugin)this);
            from = "running process";
        } else {
            from = "properties";
        }
        String[] classpath = super.getClassPath(manager);
        if (installDir == null) {
            this.getLog().debug((Object)(prop + " not configured"));
            return classpath;
        }
        this.getLog().debug((Object)("Setting " + prop + "=" + installDir + ", configured from " + from));
        for (int i = 0; i < classpath.length; ++i) {
            File jar = new File(installDir, classpath[i]);
            if (!jar.exists()) continue;
            classpath[i] = jar.getPath();
        }
        return classpath;
    }

    protected static boolean isBrandedServer(File installpath, String earDir) {
        String ear = "deploy" + File.separator + earDir;
        return new File(installpath, ear).exists();
    }
}

