/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss;

import java.util.Arrays;
import org.hyperic.hq.plugin.jboss.JBossUtil;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;

public class JBossServiceControlPlugin
extends ControlPlugin {
    static final String DEFAULT_ATTRIBUTE = "StateString";
    private Metric configuredMetric;

    protected String getAttribute() {
        String attr = this.getTypeProperty("ATTRIBUTE_NAME");
        if (attr != null) {
            return attr;
        }
        return DEFAULT_ATTRIBUTE;
    }

    private String getTemplate() {
        return this.getObjectName() + ":" + this.getAttribute() + ":" + this.getPluginProperty("template-config");
    }

    protected Metric getConfiguredMetric() {
        if (this.configuredMetric == null) {
            String template = this.getTemplate();
            this.configuredMetric = JBossUtil.configureMetric(this, template);
            this.getLog().debug((Object)("Configured metric=" + this.configuredMetric));
        }
        return this.configuredMetric;
    }

    protected String getObjectName() {
        String objectName = this.getTypeProperty("OBJECT_NAME");
        if (objectName == null) {
            String msg = "OBJECT_NAME property undefined for " + this.getTypeInfo().getName();
            throw new IllegalArgumentException(msg);
        }
        return objectName;
    }

    public void doAction(String action, String[] args) throws PluginException {
        this.invokeMethod(action, args);
    }

    protected void invokeMethod(String action) {
        this.invokeMethod(action, new String[0]);
    }

    protected void invokeMethod(String action, String[] args) {
        this.getLog().debug((Object)("invoking " + action + " " + Arrays.asList(args)));
        try {
            Object obj = JBossUtil.invoke(this.getConfiguredMetric(), action, args, new String[0]);
            this.getLog().debug((Object)(this.getConfiguredMetric() + "." + action + "() returned: " + obj));
            this.setResult(0);
            if (obj != null) {
                this.setMessage(obj.toString());
            }
        }
        catch (MetricInvalidException e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
            this.setMessage(e.getMessage());
            this.setResult(-1);
        }
        catch (MetricUnreachableException e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
            this.setMessage(e.getMessage());
            this.setResult(-1);
        }
        catch (PluginException e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
            this.setMessage(e.getMessage());
            this.setResult(-2);
        }
        catch (Exception e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
            this.setMessage(e.getMessage());
            this.setResult(-2);
        }
    }
}

