/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss7;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.jboss7.JBoss7DefaultCollector;
import org.hyperic.hq.plugin.jboss7.JBossAdminHttp;
import org.hyperic.hq.plugin.jboss7.objects.DataSource;
import org.hyperic.hq.product.PluginException;

public class DataSourceCollector
extends JBoss7DefaultCollector {
    private static final Log log = LogFactory.getLog(DataSourceCollector.class);

    public void collect(JBossAdminHttp admin) {
        String ds = (String)this.getProperties().get("datasource");
        try {
            DataSource datasource = admin.getDatasource(ds, true, this.getPlugin().getTypeInfo().getVersion());
            this.setAvailability(datasource.isEnabled());
            this.setValue("ActiveCount", datasource.getActiveCount());
            this.setValue("AvailableCount", datasource.getAvailableCount());
            this.setValue("AverageBlockingTime", datasource.getAverageBlockingTime());
            this.setValue("AverageCreationTime", datasource.getAverageCreationTime());
            this.setValue("CreatedCount", datasource.getCreatedCount());
            this.setValue("DestroyedCount", datasource.getDestroyedCount());
            this.setValue("MaxCreationTime", datasource.getMaxCreationTime());
            this.setValue("MaxUsedCount", datasource.getMaxUsedCount());
            this.setValue("MaxWaitCount", datasource.getMaxWaitCount());
            this.setValue("MaxWaitTime", datasource.getMaxWaitTime());
            this.setValue("PreparedStatementCacheAccessCount", datasource.getPreparedStatementCacheAccessCount());
            this.setValue("PreparedStatementCacheAddCount", datasource.getPreparedStatementCacheAddCount());
            this.setValue("PreparedStatementCacheCurrentSize", datasource.getPreparedStatementCacheCurrentSize());
            this.setValue("PreparedStatementCacheDeleteCount", datasource.getPreparedStatementCacheDeleteCount());
            this.setValue("PreparedStatementCacheHitCount", datasource.getPreparedStatementCacheHitCount());
            this.setValue("PreparedStatementCacheMissCount", datasource.getPreparedStatementCacheMissCount());
            this.setValue("TimedOut", datasource.getTimedOut());
            this.setValue("TotalBlockingTime", datasource.getTotalBlockingTime());
            this.setValue("TotalCreationTime", datasource.getTotalCreationTime());
        }
        catch (PluginException ex) {
            this.setAvailability(false);
            log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public Log getLog() {
        return log;
    }
}

