/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss7;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.hyperic.hq.plugin.jboss7.JBoss7Control;
import org.hyperic.hq.plugin.jboss7.JBossAdminHttp;
import org.hyperic.hq.plugin.jboss7.objects.Connector;
import org.hyperic.hq.plugin.jboss7.objects.DataSource;
import org.hyperic.hq.plugin.jboss7.objects.Deployment;
import org.hyperic.hq.plugin.jboss7.objects.WebSubsystem;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.DaemonDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JBossDetectorBase
extends DaemonDetector
implements AutoServerDetector {
    private final Log log = this.getLog();
    protected static final String USERNAME = "jboss7.user";
    protected static final String PASSWORD = "jboss7.pass";
    protected static final String HTTPS = "jboss7.https";
    protected static final String ADDR = "jboss7.addr";
    protected static final String PORT = "jboss7.port";
    protected static final String SERVER = "jboss7.server";
    protected static final String HOST = "jboss7.host";
    protected static final String CONFIG = "jboss7.conf";

    abstract String getPidsQuery();

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        long[] pids = JBossDetectorBase.getPids((String)this.getPidsQuery());
        this.log.debug((Object)("[getServerResources] pids.length:" + pids.length));
        for (long pid : pids) {
            String AIID;
            String installPath;
            Map<String, String> args = JBossDetectorBase.parseArgs(JBossDetectorBase.getProcArgs((long)pid));
            String detectedVersion = this.getVersion(args);
            String expectedVersion = this.getTypeInfo().getVersion();
            if (expectedVersion.equals("7")) {
                expectedVersion = expectedVersion + ".0";
            }
            boolean validVersion = detectedVersion.startsWith(expectedVersion);
            this.log.debug((Object)("[getServerResources] pid='" + pid + "' expectedVersion='" + expectedVersion + "' detectedVersion='" + detectedVersion + "' validVersion='" + validVersion + "'"));
            if (!validVersion) continue;
            File cfgFile = this.getConfigFile(args);
            try {
                installPath = cfgFile.getParentFile().getParentFile().getCanonicalPath();
                AIID = cfgFile.getCanonicalPath();
            }
            catch (IOException ex) {
                installPath = cfgFile.getParentFile().getParentFile().getAbsolutePath();
                AIID = cfgFile.getAbsolutePath();
            }
            ServerResource server = this.createServerResource(installPath);
            server.setIdentifier(AIID);
            ConfigResponse productConfig = this.getServerProductConfig(args);
            this.populateListeningPorts(pid, productConfig, true);
            this.setProductConfig(server, productConfig);
            this.setControlConfig(server, this.getServerControlConfig(args));
            server.setName(this.prepareServerName(server.getProductConfig()));
            servers.add(server);
        }
        return servers;
    }

    protected final List discoverServices(ConfigResponse config) {
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        this.log.debug((Object)("[discoverServices] config=" + config));
        if (this.haveServices()) {
            ConfigResponse pc;
            ConfigResponse cp;
            ServiceResource service;
            JBossAdminHttp admin = null;
            try {
                admin = new JBossAdminHttp(config);
            }
            catch (PluginException ex) {
                this.log.error((Object)("Error connecting to JBoss: " + (Object)((Object)ex)), (Throwable)ex);
                return services;
            }
            try {
                List<String> datasources = admin.getDatasources();
                this.log.debug(datasources);
                for (String ds : datasources) {
                    DataSource datasource = admin.getDatasource(ds, false, this.getTypeInfo().getVersion());
                    service = this.createServiceResource("Datasource");
                    service.setName(this.prepareServerName(config) + " Datasource " + ds);
                    cp = new ConfigResponse();
                    cp.setValue("jndi", datasource.getJndiName());
                    cp.setValue("driver", datasource.getDriverName());
                    pc = new ConfigResponse();
                    pc.setValue("name", ds);
                    this.setProductConfig(service, pc);
                    service.setCustomProperties(cp);
                    service.setMeasurementConfig();
                    service.setControlConfig();
                    services.add(service);
                }
            }
            catch (PluginException ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
            try {
                WebSubsystem ws = admin.getWebSubsystem();
                this.log.debug((Object)ws);
                for (String name : ws.getConector().keySet()) {
                    Connector connector = ws.getConector().get(name);
                    service = this.createServiceResource("Connector");
                    service.setName(this.prepareServerName(config) + " Connector " + name);
                    cp = new ConfigResponse();
                    cp.setValue("protocol", connector.getProtocol());
                    cp.setValue("scheme", connector.getScheme());
                    pc = new ConfigResponse();
                    pc.setValue("name", name);
                    this.setProductConfig(service, pc);
                    service.setCustomProperties(cp);
                    service.setMeasurementConfig();
                    service.setControlConfig();
                    services.add(service);
                }
            }
            catch (PluginException ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
            try {
                List<Deployment> deployments = admin.getDeployments();
                for (Deployment d : deployments) {
                    ServiceResource service2 = this.createServiceResource("deployment");
                    service2.setName(this.prepareServerName(config) + " Deployment " + d.getName());
                    ConfigResponse cp2 = new ConfigResponse();
                    cp2.setValue("runtime-name", d.getRuntimeName());
                    ConfigResponse pc2 = new ConfigResponse();
                    pc2.setValue("name", d.getName());
                    this.setProductConfig(service2, pc2);
                    service2.setCustomProperties(cp2);
                    service2.setMeasurementConfig();
                    service2.setControlConfig();
                    services.add(service2);
                }
            }
            catch (PluginException ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
        }
        return services;
    }

    protected String prepareServerName(ConfigResponse cfg) {
        String type = this.getTypeInfo().getName();
        String name = JBossDetectorBase.getPlatformName() + " " + type + " ";
        String host = cfg.getValue(HOST);
        String server = cfg.getValue(SERVER);
        if (host != null) {
            name = name + host;
            if (server != null) {
                name = name + " " + server;
            }
        } else {
            name = name + cfg.getValue(ADDR) + ":" + cfg.getValue(PORT);
        }
        return name;
    }

    final String parseAddress(String address, Map<String, String> args) {
        if (address.startsWith("${")) {
            if ((address = address.substring(2, address.length() - 1)).contains(":")) {
                String[] s = address.split(":");
                if ((address = args.get(s[0])) == null) {
                    address = s[1];
                }
            } else {
                address = args.get(address);
            }
        }
        return address;
    }

    final String getVersion(Map<String, String> args) {
        String[] jars;
        String version = "not found";
        String mp = args.get("mp");
        File serverModule = new File(mp, "org/jboss/as/server/main");
        if (!serverModule.isAbsolute()) {
            serverModule = new File(args.get("jboss.home.dir"), serverModule.getPath());
        }
        if ((jars = serverModule.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("jboss-as-server") && name.endsWith(".jar");
            }
        })) != null && jars.length == 1) {
            try {
                JarFile jarFile = new JarFile(new File(serverModule, jars[0]));
                this.log.debug((Object)("[getVersion] jboss-as-server.jar = '" + jarFile.getName() + "'"));
                Attributes attributes = jarFile.getManifest().getMainAttributes();
                jarFile.close();
                version = attributes.getValue("JBossAS-Release-Version");
            }
            catch (IOException e) {
                this.log.debug((Object)("[getVersion] Error getting JBoss version (" + e + ")"), (Throwable)e);
            }
        } else {
            this.log.debug((Object)("[getVersion] serverModule=" + serverModule));
            this.log.debug((Object)"[getVersion] 'jboss-as-server.*.jar' not found.");
        }
        return version;
    }

    private static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (int n = 0; n < args.length; ++n) {
            String[] arg;
            if (args[n].startsWith("-X")) continue;
            if ((args[n].startsWith("-D") || args[n].startsWith("--")) && args[n].contains("=")) {
                arg = args[n].substring(2).split("=");
                props.put(arg[0], arg[1]);
                continue;
            }
            if (args[n].startsWith("-") && args[n].contains("=")) {
                arg = args[n].substring(1).split("=");
                props.put(arg[0], arg[1]);
                continue;
            }
            if (!args[n].startsWith("-") || args[n].contains("=")) continue;
            props.put(args[n].substring(1), args[n + 1]);
        }
        return props;
    }

    final ConfigResponse getServerProductConfig(Map<String, String> args) {
        ConfigResponse cfg = new ConfigResponse();
        String port = null;
        String address = null;
        File cfgFile = this.getConfigFile(args);
        try {
            int i;
            this.log.debug((Object)("[getProductConfig] cfgFile=" + cfgFile.getCanonicalPath()));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(cfgFile);
            XPathFactory factory = XPathFactory.newInstance();
            XPathExpression expr = factory.newXPath().compile(this.getConfigRoot() + "/management/management-interfaces/http-interface");
            Object result = expr.evaluate(doc, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)result;
            String mgntIf = null;
            for (i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getAttributes().getNamedItem("port") == null) continue;
                port = nodeList.item(i).getAttributes().getNamedItem("port").getNodeValue();
                mgntIf = nodeList.item(i).getAttributes().getNamedItem("interface").getNodeValue();
            }
            if (mgntIf != null) {
                expr = factory.newXPath().compile(this.getConfigRoot() + "/interfaces/interface[@name='" + mgntIf + "']/inet-address");
                result = expr.evaluate(doc, XPathConstants.NODESET);
                nodeList = (NodeList)result;
                for (i = 0; i < nodeList.getLength(); ++i) {
                    address = nodeList.item(i).getAttributes().getNamedItem("value").getNodeValue();
                }
            }
            this.setUpExtraProductConfig(cfg, doc);
        }
        catch (Exception ex) {
            this.log.debug((Object)("Error discovering the jmx.url : " + ex), (Throwable)ex);
        }
        this.log.debug((Object)("[getProductConfig] address='" + address + "' port='" + port + "'"));
        if (address != null && port != null) {
            cfg.setValue(PORT, port);
            cfg.setValue(ADDR, this.parseAddress(address, args));
        }
        return cfg;
    }

    final ConfigResponse getServerControlConfig(Map<String, String> args) {
        ConfigResponse cf = new ConfigResponse();
        String baseDir = args.get("jboss.home.dir");
        String name = args.get("jboss.domain.default.config");
        if (name == null && (name = args.get("server-config")) == null) {
            name = this.getDefaultConfigName();
        }
        this.log.debug((Object)("[getServerControlConfig] baseDir = " + baseDir));
        this.log.debug((Object)("[getServerControlConfig] name = " + name));
        if (name != null && baseDir != null) {
            name = name.substring(0, name.lastIndexOf(".")) + (JBossDetectorBase.isWin32() ? ".bat" : ".sh");
            File script = new File(new File(baseDir, "bin"), name);
            cf.setValue(JBoss7Control.START_SCRIPT, script.getAbsolutePath());
            this.log.debug((Object)("[getServerControlConfig] script = " + script));
        }
        return cf;
    }

    void setUpExtraProductConfig(ConfigResponse cfg, Document doc) throws XPathException {
    }

    final File getConfigFile(Map<String, String> args) {
        File cfgFile;
        String serverConfig = args.get("server-config");
        if (serverConfig == null) {
            serverConfig = this.getDefaultConfigName();
        }
        if (!(cfgFile = new File(serverConfig)).isAbsolute()) {
            String configDir = args.get("jboss.server.config.dir");
            if (configDir == null) {
                String baseDir = args.get("jboss.server.base.dir");
                if (baseDir == null) {
                    baseDir = args.get("jboss.home.dir") + this.getDefaultConfigDir();
                }
                configDir = baseDir + "/configuration";
            }
            cfgFile = new File(configDir, serverConfig);
        }
        return cfgFile;
    }

    abstract String getConfigRoot();

    abstract String getDefaultConfigName();

    abstract String getDefaultConfigDir();

    abstract boolean haveServices();

    private void populateListeningPorts(long pid, ConfigResponse productConfig, boolean b) {
        try {
            Class<?> du = Class.forName("org.hyperic.hq.product.DetectionUtil");
            Method plp = du.getMethod("populateListeningPorts", Long.TYPE, ConfigResponse.class, Boolean.TYPE);
            plp.invoke(null, pid, productConfig, b);
        }
        catch (ClassNotFoundException ex) {
            this.log.debug((Object)"[populateListeningPorts] Class 'DetectionUtil' not found", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            this.log.debug((Object)"[populateListeningPorts] Method 'populateListeningPorts' not found", (Throwable)ex);
        }
        catch (Exception ex) {
            this.log.debug((Object)"[populateListeningPorts] Problem with Method 'populateListeningPorts'", (Throwable)ex);
        }
    }
}

