/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.util.security.DefaultSSLProviderImpl;
import org.hyperic.util.security.KeystoreConfig;

public class LDAPSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory socketFactory;

    public LDAPSSLSocketFactory() {
        DefaultSSLProviderImpl sslProvider = new DefaultSSLProviderImpl((KeystoreConfig)new AgentKeystoreConfig(), true);
        this.socketFactory = sslProvider.getSSLContext().getSocketFactory();
    }

    public static SocketFactory getDefault() {
        return new LDAPSSLSocketFactory();
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.socketFactory.createSocket(s, host, port, autoClose);
    }

    public String[] getDefaultCipherSuites() {
        return this.socketFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.socketFactory.getSupportedCipherSuites();
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.socketFactory.createSocket(address, port, localAddress, localPort);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port, localHost, localPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port);
    }
}

