/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilException;
import com.microsoft.util.UtilTempBuffer;
import java.io.IOException;
import java.io.OutputStream;

public class UtilTempBufferOutputStream
extends OutputStream {
    private static String footprint = "$Revision:   1.0.1.0  $";
    private UtilTempBuffer tempBuffer;
    private int currentPos;

    public UtilTempBufferOutputStream(UtilTempBuffer utilTempBuffer) {
        this.tempBuffer = utilTempBuffer;
        this.currentPos = 0;
    }

    public void close() throws IOException {
        this.tempBuffer = null;
        this.currentPos = -1;
    }

    private String getExceptionMessage(int n) {
        UtilException utilException = new UtilException(n);
        return utilException.getMessage();
    }

    public void write(int n) throws IOException {
        try {
            this.tempBuffer.write((long)this.currentPos, (byte)n);
            ++this.currentPos;
        }
        catch (UtilException utilException) {
            throw new IOException(utilException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(this.getExceptionMessage(1017));
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.tempBuffer.write(this.currentPos, byArray, n, n2);
            this.currentPos += n2;
        }
        catch (UtilException utilException) {
            throw new IOException(utilException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(this.getExceptionMessage(1017));
        }
    }
}

