/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.hqagent;

import org.hyperic.hq.agent.AgentMonitorValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.SigarMeasurementPlugin;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public class AgentMeasurementPlugin
extends SigarMeasurementPlugin {
    private static final String AVAIL_TMPL = "camAgent:availability";

    public AgentMeasurementPlugin() {
        this.setName("camagent");
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        return new ConfigSchema();
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        AgentDaemon agent = AgentDaemon.getMainInstance();
        if (agent == null) {
            throw new PluginException("Agent.getValue() called when plugin not running from within the Agent");
        }
        if (metric.toString().equals(AVAIL_TMPL)) {
            return new MetricValue(1.0);
        }
        if (metric.getDomainName().equals("camAgent")) {
            return this.getAgentValue(agent, metric);
        }
        if (metric.getDomainName().equals("sigar")) {
            return this.getSigarValue(metric);
        }
        throw new MetricInvalidException("Invalid JMX domain '" + metric.getDomainName() + "'");
    }

    private MetricValue getSigarValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        return super.getValue(metric);
    }

    private MetricValue getAgentValue(AgentDaemon agent, Metric metric) throws PluginException {
        String monitorName = metric.getObjectProperty("Monitor");
        String monitorVal = metric.getAttributeName();
        if (monitorName == null || monitorVal == null) {
            throw new MetricInvalidException("Metric invalid -- no Monitor key, or no attribute: " + metric);
        }
        AgentMonitorValue mVal = agent.getMonitorValues(monitorName, new String[]{monitorVal})[0];
        if (mVal.isErr()) {
            switch (mVal.getErrCode()) {
                case 1: {
                    this.getLog().debug((Object)("Unable to calculate " + metric));
                    return new MetricValue(Double.NaN);
                }
                case 2: {
                    throw new MetricInvalidException("Agent monitor '" + monitorName + "' does not have " + "a " + monitorVal + " value");
                }
                case 3: {
                    throw new MetricInvalidException("Agent monitor '" + monitorName + "' unknown");
                }
            }
            throw new PluginException("Internal error fetching '" + monitorName + ":" + monitorVal + "'");
        }
        if (mVal.getType() != 1) {
            throw new MetricInvalidException("Agent Metric '" + metric + "' " + "does not return a double");
        }
        return new MetricValue(mVal.getDoubleValue());
    }

    public String translate(String template, ConfigResponse config) {
        return template;
    }
}

