/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WeblogicConfig {
    String version;
    String domain;
    String adminPort;
    boolean adminPortEnabled;
    HashMap runningNodes = new HashMap();
    ArrayList servers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            this.parse(is);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        if (this.version != null && WeblogicConfig.majorVersion(this.version) >= 9) {
            for (int i = 0; i < this.servers.size(); ++i) {
                Server server = (Server)this.servers.get(i);
                if (server.version != null) continue;
                server.version = this.version;
            }
        }
        if (!"6.1".equals(this.version)) {
            return;
        }
        if (!(file = new File(file.getParentFile(), "running-managed-servers.xml")).exists()) {
            return;
        }
        try {
            is = new FileInputStream(file);
            this.parseRunningServers(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Server getServer(String name) {
        for (int i = 0; i < this.servers.size(); ++i) {
            Server server = (Server)this.servers.get(i);
            if (!server.name.equals(name)) continue;
            return server;
        }
        return null;
    }

    public Server guessAdminServer() {
        for (int i = 0; i < this.servers.size(); ++i) {
            Server server = (Server)this.servers.get(i);
            if (this.runningNodes.get(server.name) != null) continue;
            return server;
        }
        return (Server)this.servers.get(0);
    }

    private String getAttribute(Node node, String name) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node item = attrs.getNamedItem(name);
        if (item == null) {
            return null;
        }
        return item.getNodeValue();
    }

    private String versionSubstring(String version) {
        int ix = version.indexOf(46);
        if (ix == -1) {
            return version.substring(0, 3);
        }
        return version.substring(0, ix + 2);
    }

    public static int majorVersion(String version) {
        int ix = version.indexOf(46);
        if (ix == -1) {
            return Integer.parseInt(version);
        }
        return Integer.parseInt(version.substring(0, ix));
    }

    private String getVersion(Node node, String attr) {
        String vers = this.getAttribute(node, attr);
        if (vers != null && vers.length() >= 3) {
            return this.versionSubstring(vers);
        }
        return this.version;
    }

    private void parseRunningServers(FileInputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            if (!(line = line.trim()).equals("<server-name>")) continue;
            String name = reader.readLine();
            this.runningNodes.put(name.trim(), Boolean.TRUE);
        }
    }

    private void parse(InputStream is) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(is);
        Element domain = doc.getDocumentElement();
        this.version = this.getVersion(domain, "ConfigurationVersion");
        this.domain = this.getAttribute(domain, "Name");
        this.adminPort = this.getAttribute(domain, "AdministrationPort");
        this.adminPortEnabled = "true".equals(this.getAttribute(domain, "AdministrationPortEnabled"));
        NodeList nodes = domain.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String tag = node.getNodeName();
            if (tag.equals("Server")) {
                String addr;
                Server server = new Server();
                server.domain = this.domain;
                server.name = this.getAttribute(node, "Name");
                server.version = this.getVersion(node, "ServerVersion");
                String port = null;
                if (this.adminPortEnabled && (port = this.getAttribute(node, "AdministrationPort")) == null) {
                    port = this.adminPort;
                }
                if (port == null) {
                    port = this.getAttribute(node, "ListenPort");
                    this.adminPortEnabled = false;
                }
                if ((addr = this.getAttribute(node, "ListenAddress")) == null || "".equals(addr)) {
                    addr = "localhost";
                }
                String protocol = this.adminPortEnabled ? "t3s" : "t3";
                server.setURL(protocol, addr, port);
                this.servers.add(server);
                continue;
            }
            if (tag.equals("server")) {
                String protocol = "t3";
                String addr = "localhost";
                String port = "7001";
                Server server = new Server();
                server.domain = this.domain;
                server.version = this.version;
                NodeList srvNodes = node.getChildNodes();
                for (int j = 0; j < srvNodes.getLength(); ++j) {
                    String val;
                    Node srv = srvNodes.item(j);
                    String srvTag = srv.getNodeName();
                    if (srvTag.equals("name")) {
                        server.name = this.getText(srv);
                        continue;
                    }
                    if (srvTag.equals("listen-port")) {
                        val = this.getText(srv);
                        if (val == null) continue;
                        port = val;
                        continue;
                    }
                    if (!srvTag.equals("listen-address") || (val = this.getText(srv)) == null) continue;
                    addr = val;
                }
                server.setURL(protocol, addr, port);
                this.servers.add(server);
                continue;
            }
            if (tag.equals("configuration-version")) {
                this.version = this.versionSubstring(this.getText(node));
                continue;
            }
            if (tag.equals("name")) {
                this.domain = this.getText(node);
                continue;
            }
            if (!tag.equals("StartupClass") || this.version != null) continue;
            this.version = "6.1";
            for (int n = 0; n < this.servers.size(); ++n) {
                Server server = (Server)this.servers.get(n);
                if (server.version != null) continue;
                server.version = this.version;
            }
        }
    }

    private String getText(Node node) {
        Node child = node.getFirstChild();
        if (child == null) {
            return null;
        }
        String value = child.getNodeValue();
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    private static void testConfig(String file) throws Exception {
        WeblogicConfig cfg = new WeblogicConfig();
        cfg.read(new File(file));
        System.out.println(cfg.version);
        System.out.println(cfg.domain);
        System.out.println("admin=" + cfg.guessAdminServer().name);
        for (int i = 0; i < cfg.servers.size(); ++i) {
            Server server = (Server)cfg.servers.get(i);
            Properties props = server.getProperties();
            props.put("version", server.getVersion());
            props.list(System.out);
        }
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[0] + "...");
            WeblogicConfig.testConfig(args[0]);
        }
    }

    class Server {
        String domain;
        String name;
        String version;
        String url;

        Server() {
        }

        public Properties getProperties() {
            Properties props = new Properties();
            props.setProperty("domain", this.domain);
            props.setProperty("admin.url", this.url);
            props.setProperty("server.url", this.url);
            props.setProperty("server", this.name);
            return props;
        }

        public String getVersion() {
            if (this.version == null) {
                return "6.1";
            }
            return this.version;
        }

        private void setURL(String protocol, String addr, String port) {
            this.url = protocol + "://" + addr + ":" + port;
        }

        public String toString() {
            return "[domain='" + this.domain + "' name='" + this.name + "' version='" + this.version + "' url='" + this.url + "']";
        }
    }
}

