/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.weblogic.WeblogicConfig;
import org.hyperic.hq.plugin.weblogic.WeblogicDetector;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.ServiceConfig;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.timer.StopWatch;

public class WeblogicFinder {
    private static final String BEASVC_EXE = "beasvc.exe";
    private static final String NOTE_BEASVC_EXE = "weblogic.beasvc.exe";
    private static final Log log = LogFactory.getLog((String)WeblogicFinder.class.getName());
    private static final String REG_SERVICES = "System\\CurrentControlSet\\Services\\";
    private static final HashMap skipDirs = new HashMap();

    private static String getCanonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getWindowsServices() {
        List names;
        ArrayList<WeblogicService> windowsServices = new ArrayList<WeblogicService>();
        StopWatch timer = new StopWatch();
        try {
            names = Service.getServiceNames();
        }
        catch (Win32Exception e) {
            return windowsServices;
        }
        for (int i = 0; i < names.size(); ++i) {
            Service service = null;
            try {
                service = new Service((String)names.get(i));
                ServiceConfig config = service.getConfig();
                String path = config.getPath().trim();
                if (!path.endsWith(BEASVC_EXE)) continue;
                WeblogicService beaSvc = new WeblogicService(config);
                windowsServices.add(beaSvc);
                continue;
            }
            catch (Win32Exception e) {
                continue;
            }
            finally {
                if (service != null) {
                    service.close();
                }
            }
        }
        log.debug((Object)("beasvc.exe matches=" + windowsServices.size() + ", took: " + timer));
        return windowsServices;
    }

    static File getServiceInstallPath() {
        return WeblogicFinder.getServiceInstallPath(null);
    }

    static File getServiceInstallPath(String version) {
        WeblogicService service = WeblogicFinder.getWeblogicService(version, false);
        if (service == null) {
            return null;
        }
        File dir = WeblogicFinder.getInstallRoot(service.getBinaryPath());
        return dir;
    }

    static List getAdminServicePaths(WeblogicDetector plugin) {
        ArrayList<File> paths = new ArrayList<File>();
        String version = plugin.getTypeInfo().getVersion();
        Map notes = plugin.getManager().getNotes();
        List windowsServices = (List)notes.get(NOTE_BEASVC_EXE);
        if (windowsServices == null) {
            windowsServices = WeblogicFinder.getWindowsServices();
            notes.put(NOTE_BEASVC_EXE, windowsServices);
        }
        List services = WeblogicFinder.getWeblogicServices(windowsServices, version, true);
        for (int i = 0; i < services.size(); ++i) {
            WeblogicService service = (WeblogicService)services.get(i);
            paths.add(new File(service.getExecDir()));
            File installpath = WeblogicFinder.getInstallRoot(service.getBinaryPath());
            if (installpath == null) continue;
            plugin.adjustWeblogicClassPath(installpath.getPath());
        }
        return paths;
    }

    private static List getWeblogicServices(List services, String version, boolean adminOnly) {
        ArrayList<WeblogicService> wls = new ArrayList<WeblogicService>();
        if (services == null) {
            services = WeblogicFinder.getWindowsServices();
        }
        char v = '\u0000';
        if (version != null) {
            v = version.charAt(0);
        }
        for (int i = 0; i < services.size(); ++i) {
            WeblogicService service = (WeblogicService)services.get(i);
            if (adminOnly && !service.isAdminServer() || v != '\u0000' && service.getBinaryPath().indexOf(v) == -1) continue;
            wls.add(service);
        }
        return wls;
    }

    private static WeblogicService getWeblogicService(String version, boolean adminOnly) {
        List services = WeblogicFinder.getWeblogicServices(null, version, adminOnly);
        if (services.size() == 0) {
            return null;
        }
        return (WeblogicService)services.get(0);
    }

    public static File getInstallRoot(String dir) {
        return WeblogicFinder.getInstallRoot(new File(dir));
    }

    public static File getInstallRoot(File dir) {
        while (dir != null) {
            if (new File(dir, "server").exists()) {
                return dir;
            }
            dir = dir.getParentFile();
        }
        return null;
    }

    private static File[] find(File dir, final List configs) {
        File[] dirs = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.getName().equals("console.war") || file.getName().equals("console")) {
                    configs.add(file);
                    return false;
                }
                return file.isDirectory() && skipDirs.get(file.getName()) != Boolean.TRUE;
            }
        });
        if (dirs == null) {
            return new File[0];
        }
        return dirs;
    }

    public static void search(File dir, List configs) {
        File[] dirs = WeblogicFinder.find(dir, configs);
        for (int i = 0; i < dirs.length; ++i) {
            WeblogicFinder.search(dirs[i], configs);
        }
    }

    public static List getSearchDirs(File root) {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(new File(root.getParentFile(), "user_projects"));
        File samples = new File(root, "samples");
        File versionSamples = new File(samples, "domains");
        if (versionSamples.exists()) {
            dirs.add(versionSamples);
        } else {
            versionSamples = new File(samples, "server" + File.separator + "config");
            dirs.add(versionSamples);
        }
        return dirs;
    }

    private static void seekAndDisplay(File dir) throws Exception {
        if (!dir.exists()) {
            System.out.println(dir + " does not exist.");
            return;
        }
        System.out.println("Scanning " + dir + "\n");
        ArrayList configs = new ArrayList();
        StopWatch timer = new StopWatch();
        WeblogicFinder.search(dir, configs);
        System.out.println("Search " + dir + " took: " + timer);
        String[] cArgs = new String[1];
        for (int i = 0; i < configs.size(); ++i) {
            File war = (File)configs.get(i);
            File path = war.getParentFile().getParentFile().getParentFile();
            File configXML = new File(path, "config.xml");
            System.out.println("-->" + configXML);
            cArgs[0] = configXML.getAbsolutePath();
            WeblogicConfig.main(cArgs);
            System.out.println("");
        }
    }

    public static void main(String[] args) throws Exception {
        String path = args.length == 0 ? WeblogicDetector.getRunningInstallPath() : args[0];
        File dir = new File(path);
        List searchDirs = WeblogicFinder.getSearchDirs(dir);
        for (int j = 0; j < searchDirs.size(); ++j) {
            WeblogicFinder.seekAndDisplay((File)searchDirs.get(j));
        }
    }

    static {
        skipDirs.put("ldap", Boolean.TRUE);
        skipDirs.put("logs", Boolean.TRUE);
        skipDirs.put(".wlnotdelete", Boolean.TRUE);
    }

    private static class WeblogicService {
        private ServiceConfig _config;
        private String _cmdLine;
        private String _execDir;
        private String _binaryPath;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WeblogicService(ServiceConfig config) throws Win32Exception {
            this._config = config;
            String path = WeblogicFinder.REG_SERVICES + config.getName() + "\\Parameters";
            RegistryKey key = RegistryKey.LocalMachine.openSubKey(path);
            try {
                this._cmdLine = key.getStringValue("CmdLine").trim();
                this._execDir = key.getStringValue("ExecDir").trim();
                this._execDir = WeblogicFinder.getCanonicalPath(this._execDir);
            }
            finally {
                key.close();
            }
        }

        private String getBinaryPath() {
            if (this._binaryPath == null) {
                this._binaryPath = WeblogicFinder.getCanonicalPath(this._config.getPath().trim());
            }
            return this._binaryPath;
        }

        private String getExecDir() {
            return this._execDir;
        }

        private boolean isServer() {
            return this._cmdLine.endsWith("weblogic.Server");
        }

        private boolean isManagedServer() {
            return this._cmdLine.indexOf("-Dweblogic.management.server") != -1;
        }

        private boolean isAdminServer() {
            return this.isServer() && !this.isManagedServer();
        }
    }
}

