/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.util.HashMap;
import java.util.Map;
import org.hyperic.hq.plugin.weblogic.WeblogicConfig;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;

public class WeblogicMetric {
    public static final String PROP_ADMIN_URL = "admin.url";
    public static final String PROP_ADMIN_USERNAME = "admin.username";
    public static final String PROP_ADMIN_PASSWORD = "admin.password";
    public static final String PROP_SERVER_URL = "server.url";
    public static final String PROP_NODEMGR_ADDR = "nodemgr.address";
    public static final String PROP_NODEMGR_PORT = "nodemgr.port";
    public static final String PROP_DOMAIN = "domain";
    public static final String PROP_SERVER = "server";
    public static final String PROP_REALM = "realm";
    public static final String PROP_JVM = "jvm.runtime";
    public static final String PROP_APP = "application";
    public static final String PROP_WEBAPP = "webapp";
    public static final String PROP_WEBAPP_DIR = "webapp.dir";
    public static final String PROP_EJB = "ejb";
    public static final String PROP_EJB_COMPONENT = "ejb.component";
    public static final String PROP_EXQ = "exq";
    public static final String PROP_JDBC_CONN = "jdbc.conn";
    public static final String PROP_JMS_SRV = "jms.server";
    public static final String PROP_JMS_DEST = "jms.destination";
    public static final String PROP_JTA_RES = "jta.resource";
    private static String LOCATION = "%domain%:Location=%server%,";
    private static String RUNTIME_LOCATION = LOCATION + "ServerRuntime=%server%,";
    static final String SERVER_RUNTIME = LOCATION + "Name=%server%," + "Type=ServerRuntime";
    private static final String SERVER_SECURITY_RUNTIME = LOCATION + "Name=%server%," + "Type=ServerSecurityRuntime";
    private static final String JVM_RUNTIME = RUNTIME_LOCATION + "Name=%server%," + "Type=";
    static final String SERVER_RUNTIME_STATE = "StateVal";
    private static final String JDBC_CONNECTION_POOL_RUNTIME = RUNTIME_LOCATION + "Name=%jdbc.conn%," + "Type=JDBCConnectionPoolRuntime";
    static final String JDBC_CONNECTION_POOL_RUNTIME_STATE = "PoolState";
    static final String APPLICATION = LOCATION + "Name=%application%," + "Type=ApplicationConfig";
    static final String APPLICATION_STATE = "Deployed";
    private static final String APPLICATION_RUNTIME_ATTR = "ApplicationRuntime=%server%_%application%";
    private static final String APPLICATION_RUNTIME_ATTR_9 = "ApplicationRuntime=%application%";
    private static final String WEBAPP_COMPONENT_RUNTIME = RUNTIME_LOCATION + "Type=WebAppComponentRuntime";
    static final String WEBAPP_COMPONENT_RUNTIME_STATUS = "Status";
    static final String WEBAPP_COMPONENT = "%domain%:Application=%application%,Name=%webapp%,Type=WebAppComponent";
    private static final String EJB_COMPONENT_RUNTIME = RUNTIME_LOCATION + "Type=EJBComponentRuntime";
    static final String EJB_COMPONENT_RUNTIME_STATUS = "Status";
    static final String EJB_COMPONENT = "%domain%:Application=%application%,Name=%ejb%,Type=EJBComponent";
    private static final String JMS_DEST_RUNTIME = RUNTIME_LOCATION + "JMSServerRuntime=%jms.server%," + "Name=%jms.destination%," + "Type=JMSDestinationRuntime";
    private static final String CONNECTOR_SERVICE_RUNTIME = RUNTIME_LOCATION + "Type=ConnectorServiceRuntime," + "Name=ConnectorService";
    private static final String TX_RESOURCE_RUNTIME = RUNTIME_LOCATION + "Type=TransactionResourceRuntime";
    private static final String[] CONFIG_PROPS = new String[]{"admin.url", "admin.username", "admin.password"};
    private static final String CONFIG_TMPL = Metric.configTemplate((String[])CONFIG_PROPS);

    static String getObjectTemplate(String version, String type) {
        return (String)WeblogicMetric.getMetricProps(version).get(type);
    }

    static String getObjectTemplate(GenericPlugin plugin, String type) {
        return WeblogicMetric.getObjectTemplate(plugin.getTypeInfo().getVersion(), type);
    }

    static Map getMetricProps(String typeVersion) {
        String ejbAttrs;
        int version = WeblogicConfig.majorVersion(typeVersion);
        HashMap<String, String> props = new HashMap<String, String>();
        if (version >= 9) {
            props.put("ServerSecurityRuntime", SERVER_SECURITY_RUNTIME + ",ServerRuntime=%server%");
            props.put("ConnectorServiceRuntime", CONNECTOR_SERVICE_RUNTIME);
            props.put("JVMRuntime", JVM_RUNTIME + "%jvm.runtime%");
            props.put("JDBCConnectionPoolRuntime", JDBC_CONNECTION_POOL_RUNTIME + "," + APPLICATION_RUNTIME_ATTR_9);
            props.put("TxResourceRuntime", TX_RESOURCE_RUNTIME + ",Name=%jta.resource%" + ",JTARuntime=JTARuntime");
            props.put("WebAppComponentRuntime", WEBAPP_COMPONENT_RUNTIME + "," + APPLICATION_RUNTIME_ATTR_9 + "," + "Name=%webapp%");
            props.put("EJBComponentRuntime", EJB_COMPONENT_RUNTIME + "," + APPLICATION_RUNTIME_ATTR_9 + "," + "Name=%ejb%");
            ejbAttrs = "ApplicationRuntime=%application%,Name=%ejb%";
        } else {
            String ejbName;
            props.put("ServerSecurityRuntime", SERVER_SECURITY_RUNTIME);
            props.put("ConnectorServiceRuntime", CONNECTOR_SERVICE_RUNTIME + "Runtime");
            props.put("JVMRuntime", JVM_RUNTIME + "JVMRuntime");
            props.put("JDBCConnectionPoolRuntime", JDBC_CONNECTION_POOL_RUNTIME);
            props.put("TxResourceRuntime", TX_RESOURCE_RUNTIME + ",Name=JTAResourceRuntime_%jta.resource%");
            String webappRuntime = WEBAPP_COMPONENT_RUNTIME + "," + "Name=%server%_%server%_%application%_%webapp%";
            if (version == 6) {
                ejbName = "Name=%application%_%ejb%";
                props.put("EJBComponentRuntime", EJB_COMPONENT_RUNTIME + "," + ejbName);
                ejbAttrs = ejbName;
            } else {
                ejbName = "Name=%server%_%application%_%ejb%";
                props.put("EJBComponentRuntime", EJB_COMPONENT_RUNTIME + "," + APPLICATION_RUNTIME_ATTR + "," + ejbName);
                webappRuntime = webappRuntime + ",ApplicationRuntime=%server%_%application%";
                ejbAttrs = "ApplicationRuntime=%server%_%application%," + ejbName;
            }
            props.put("WebAppComponentRuntime", webappRuntime);
        }
        props.put("ServerRuntime", SERVER_RUNTIME);
        props.put("Application", APPLICATION);
        props.put("JMSDestinationRuntime", JMS_DEST_RUNTIME);
        String[] ejbTypes = new String[]{"EntityEJB", "MessageDrivenEJB", "StatelessEJB", "StatefulEJB", "EJBTransaction", "EJBPool", "EJBCache", "EJBLocking"};
        for (int i = 0; i < ejbTypes.length; ++i) {
            String name = ejbTypes[i] + "Runtime";
            String oname = RUNTIME_LOCATION + "Type=" + name + "," + "EJBComponentRuntime=%ejb.component%" + "," + ejbAttrs;
            if (name.startsWith("EJB") && version >= 9) {
                oname = oname + ",${BeanType}Runtime=%ejb%";
            }
            props.put(name, oname);
        }
        props.put("Location", LOCATION);
        props.put("RuntimeLocation", RUNTIME_LOCATION);
        return props;
    }

    static String template(String objectName, String attr) {
        return objectName + ":" + attr + ":" + CONFIG_TMPL;
    }

    static String translateNode(String template, ConfigResponse config) {
        String pat = "%admin.url%";
        String node = config.getValue(PROP_SERVER_URL);
        if (node != null) {
            template = StringUtil.replace((String)template, (String)"%admin.url%", (String)node);
        }
        return template;
    }
}

