/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.weblogic.WeblogicDetector;
import org.hyperic.hq.plugin.weblogic.WeblogicFinder;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;

public class WeblogicProductPlugin
extends ProductPlugin {
    private static boolean useJAAS = true;
    private static boolean autoRT = false;
    public static boolean NEW_DISCOVERY = false;
    public static boolean usePlatformName = false;
    private static boolean ssl2ways = false;
    private static String ssl2ways_cert;
    private static String ssl2ways_key;
    private static String ssl2ways_key_pass;
    public static final String NAME = "weblogic";
    public static final String SERVER_NAME = "Weblogic";
    public static final String ADMIN_NAME = "Weblogic Admin";
    public static final String NODEMGR_NAME = "Weblogic NodeManager";
    public static final String VERSION_61 = "6.1";
    public static final String APP_NAME = "Application";
    public static final String EXQ_NAME = "Execute Queue";
    public static final String JDBC_CONN_NAME = "JDBC Connection Pool";
    public static final String JMS_SRV_NAME = "JMS Server";
    public static final String JMS_DEST_NAME = "JMS Destination";
    public static final String JTA_RES_NAME = "JTA Resource";
    public static final String WEBAPP_NAME = "Webapp";
    public static final String ENTITY_EJB_NAME = "Entity EJB";
    public static final String MDB_EJB_NAME = "Message Driven EJB";
    public static final String STATELESS_EJB_NAME = "Stateless EJB";
    public static final String STATEFUL_EJB_NAME = "Stateful EJB";
    public static final String PROP_INSTALLPATH = "weblogic.installpath";
    private static Log log;

    public static boolean useJAAS() {
        return useJAAS;
    }

    public static boolean useSSL2Ways() {
        return ssl2ways;
    }

    public static String getSSL2WaysKey() {
        return ssl2ways_key;
    }

    public static String getSSL2WaysCert() {
        return ssl2ways_cert;
    }

    public static String getSSL2WaysKeyPass() {
        return ssl2ways_key_pass;
    }

    public static boolean autoRT() {
        return autoRT;
    }

    public String[] getClassPath(ProductPluginManager manager) {
        Properties props = manager.getProperties();
        String installpath = props.getProperty(PROP_INSTALLPATH);
        String auth = props.getProperty("weblogic.auth.method", "jaas").toLowerCase();
        NEW_DISCOVERY = props.getProperty("weblogic.discovery.new", "false").equalsIgnoreCase("true");
        log.debug((Object)("[getClassPath] weblogic.discovery.new=" + NEW_DISCOVERY));
        usePlatformName = props.getProperty("weblogic.discover.pname", "false").equalsIgnoreCase("true");
        log.debug((Object)("[getClassPath] usePlatformName=" + usePlatformName));
        ssl2ways_key = props.getProperty("weblogic.ssl2ways.key");
        ssl2ways_key_pass = props.getProperty("weblogic.ssl2ways.key.pass", "");
        ssl2ways_cert = props.getProperty("weblogic.ssl2ways.cert");
        String loginConfig = "java.security.auth.login.config";
        if (System.getProperty("java.security.auth.login.config") == null) {
            String pdk = System.getProperty("agent.pdkDir");
            String configFile = "jaas.config";
            String config = pdk != null ? pdk + "/../" + configFile : configFile;
            if (new File(config).exists()) {
                log.debug((Object)("-Djava.security.auth.login.config=" + config));
                System.setProperty("java.security.auth.login.config", config);
            }
        }
        if ("jndi".equals(auth) || System.getProperty("java.security.auth.login.config") == null) {
            useJAAS = false;
        } else if ("ssl2ways".equals(auth)) {
            useJAAS = false;
            ssl2ways = true;
        } else if (!"jaas".equals(auth)) {
            String msg = "Unsupported authentication method: " + auth;
            throw new IllegalArgumentException(msg);
        }
        if ("true".equals(props.getProperty("weblogic.autort"))) {
            autoRT = true;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("weblogic.security.")) continue;
            System.setProperty(key, (String)entry.getValue());
        }
        String expire = props.getProperty("weblogic.attrcache.expire");
        if (expire != null) {
            System.setProperty("weblogic.attrcache.expire", expire);
        }
        String[] classpath = super.getClassPath(manager);
        if (installpath == null) {
            String dir;
            File path = null;
            if (path == null && (dir = WeblogicDetector.getRunningInstallPath()) != null) {
                path = new File(dir);
            }
            if (path == null && WeblogicProductPlugin.isWin32()) {
                path = WeblogicFinder.getServiceInstallPath();
            }
            if (path == null) {
                return classpath;
            }
            installpath = path.getAbsolutePath();
            log.info((Object)("weblogic.installpath not set, defaulting to: " + installpath));
        }
        String wlHome = props.getProperty("weblogic.home", new File(installpath, "server").toString());
        System.setProperty("weblogic.home", wlHome);
        String beaHome = props.getProperty("bea.home", new File(installpath).getParentFile().toString());
        System.setProperty("bea.home", beaHome);
        File weblogicJar = new File(installpath, "lib/weblogic.jar");
        try {
            if (weblogicJar.getCanonicalFile().exists()) {
                useJAAS = false;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int i = 0; i < classpath.length; ++i) {
            File jar = new File(installpath, classpath[i]);
            if (!jar.exists()) continue;
            classpath[i] = jar.getPath();
        }
        return classpath;
    }

    static {
        log = LogFactory.getLog(WeblogicProductPlugin.class);
    }
}

