/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import java.util.Hashtable;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hyperic.hq.plugin.weblogic.jmx.ServerQuery;
import org.hyperic.hq.plugin.weblogic.jmx.ServiceQuery;

public class JDBCPoolQuery
extends ServiceQuery {
    public static final String MBEAN_TYPE = "JDBCConnectionPoolRuntime";
    private static final String[] CONFIG_ATTRS = new String[]{"DriverName", "URL"};

    public String getMBeanType() {
        return MBEAN_TYPE;
    }

    public String getResourceType() {
        return "JDBC Connection Pool";
    }

    public String getPropertyName() {
        return "jdbc.conn";
    }

    private ObjectName getPoolConfig() {
        ServerQuery server = (ServerQuery)this.getParent();
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put("Type", "JDBCConnectionPoolConfig");
        attributes.put("Name", this.getName());
        attributes.put("Location", server.getName());
        try {
            return new ObjectName(server.getDiscover().getDomain(), attributes);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public boolean getAttributes(MBeanServer mServer, ObjectName name) {
        super.getAttributes(mServer, name);
        super.getAttributes(mServer, this.getPoolConfig(), CONFIG_ATTRS);
        String app = name.getKeyProperty("ApplicationRuntime");
        if (app != null) {
            this.attrs.put("application", app);
        }
        return true;
    }

    public String[] getCustomPropertiesNames() {
        return CONFIG_ATTRS;
    }

    public Properties getResourceConfig() {
        Properties props = super.getResourceConfig();
        String app = this.getAttribute("application");
        if (app != null) {
            props.setProperty("application", app);
        }
        return props;
    }
}

