/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import java.io.File;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.hyperic.hq.plugin.weblogic.jmx.BaseServerQuery;
import org.hyperic.hq.plugin.weblogic.jmx.ServerQuery;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicQuery;
import org.hyperic.hq.product.TypeBuilder;

public class NodeManagerQuery
extends BaseServerQuery {
    public static final String MBEAN_TYPE = "NodeManager";
    private static final String[] ATTRS = new String[]{"ListenAddress", "ListenPort"};
    private ServerQuery adminServer;

    public void setAdminServer(ServerQuery adminServer) {
        this.adminServer = adminServer;
    }

    public WeblogicQuery cloneInstance() {
        NodeManagerQuery query = (NodeManagerQuery)super.cloneInstance();
        query.adminServer = this.adminServer;
        return query;
    }

    public String getMBeanType() {
        return MBEAN_TYPE;
    }

    public String getResourceType() {
        String type = "Weblogic NodeManager";
        String version = this.adminServer.getVersion();
        return TypeBuilder.composeServerTypeName((String)"Weblogic NodeManager", (String)version);
    }

    public String getPropertyName() {
        return "server";
    }

    public boolean getAttributes(MBeanServer mServer, ObjectName name) {
        String mgrName = name.getKeyProperty("Name");
        this.setName(mgrName);
        return this.getAttributes(mServer, name, ATTRS);
    }

    public void configure(Properties props) {
        super.configure(props);
        this.adminServer.configureAdminProps(props);
        props.setProperty("nodemgr.address", this.getListenAddress());
        props.setProperty("nodemgr.port", this.getListenPort());
    }

    public String getQualifiedName() {
        return this.adminServer.getDiscover().getDomain() + " " + this.getName();
    }

    public String getIdentifier() {
        return this.getResourceFullName();
    }

    public String getInstallPath() {
        String wlHome = System.getProperty("weblogic.home", "/usr/local/bea/weblogic81/server");
        File home = new File(wlHome).getParentFile();
        return home + File.separator + "common" + File.separator + "nodemanager";
    }

    public boolean hasControl() {
        return false;
    }
}

