/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.weblogic.WeblogicUtil;
import org.hyperic.hq.plugin.weblogic.jmx.ApplicationQuery;
import org.hyperic.hq.plugin.weblogic.jmx.ExqQuery;
import org.hyperic.hq.plugin.weblogic.jmx.JDBCPoolQuery;
import org.hyperic.hq.plugin.weblogic.jmx.JMSServerQuery;
import org.hyperic.hq.plugin.weblogic.jmx.JTAResourceQuery;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicDiscoverException;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicQuery;

public class WeblogicDiscover {
    private static Log log = LogFactory.getLog(WeblogicDiscover.class);
    private String adminName = null;
    private String version;
    private String domain = null;
    private Properties props;
    private HashMap mbeanServers = new HashMap();
    private HashMap internalApps = new HashMap();
    private final WeblogicQuery[] SERVICE_QUERIES = new WeblogicQuery[]{new ApplicationQuery(), new JDBCPoolQuery(), new ExqQuery(), new JMSServerQuery(), new JTAResourceQuery()};

    public WeblogicDiscover(String version, Properties props) {
        this.version = version;
        this.props = props;
    }

    public String getVersion() {
        return this.version;
    }

    public static Log getLog() {
        return log;
    }

    private Properties getProperties(String adminURL, String username, String password) {
        Properties props = new Properties();
        props.put("admin.url", adminURL);
        props.put("admin.username", username);
        props.put("admin.password", password);
        return props;
    }

    public boolean isAdminSSL() {
        return this.getAdminURL().startsWith("t3s");
    }

    public String getAdminURL() {
        return this.getAdminURL(this.props);
    }

    public String getUsername() {
        return this.getUsername(this.props);
    }

    public String getPassword() {
        return this.getPassword(this.props);
    }

    public String getAdminURL(Properties props) {
        return props.getProperty("admin.url");
    }

    public String getUsername(Properties props) {
        return props.getProperty("admin.username");
    }

    public String getPassword(Properties props) {
        return props.getProperty("admin.password", "");
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public MBeanServer getMBeanServer() throws WeblogicDiscoverException {
        return this.getMBeanServer(this.props);
    }

    public MBeanServer getMBeanServer(String url) throws WeblogicDiscoverException {
        return this.getMBeanServer(url, this.getUsername(), this.getPassword());
    }

    public MBeanServer getMBeanServer(String url, String user, String pass) throws WeblogicDiscoverException {
        return this.getMBeanServer(this.getProperties(url, user, pass));
    }

    public MBeanServer getMBeanServer(Properties props) throws WeblogicDiscoverException {
        String url = this.getAdminURL(props);
        MBeanServer server = (MBeanServer)this.mbeanServers.get(url);
        if (server != null) {
            return server;
        }
        try {
            server = WeblogicUtil.getMBeanServer(props);
        }
        catch (Exception e) {
            throw new WeblogicDiscoverException(e.getMessage(), e);
        }
        this.mbeanServers.put(url, server);
        return server;
    }

    public void find(MBeanServer mServer, WeblogicQuery query, List types) throws WeblogicDiscoverException {
        ObjectName scope;
        try {
            scope = new ObjectName(this.domain + ":" + query.getScope() + ",*");
            log.debug((Object)("[find] scope=" + scope));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            for (ObjectName obj : mServer.queryNames(scope, null)) {
                WeblogicQuery type;
                String name = obj.getKeyProperty("Name");
                if (name != null && (name.startsWith("__") || name.indexOf("uuid-") != -1) || !(type = query.cloneInstance()).getAttributes(mServer, obj)) continue;
                types.add(type);
                WeblogicQuery[] childQueries = query.getChildQueries();
                for (int i = 0; i < childQueries.length; ++i) {
                    WeblogicQuery childQuery = childQueries[i];
                    childQuery.setParent(type);
                    childQuery.setVersion(type.getVersion());
                    this.find(mServer, childQuery, types);
                }
            }
        }
        catch (Exception e) {
            throw new WeblogicDiscoverException(e);
        }
    }

    public void init(MBeanServer mServer) throws WeblogicDiscoverException {
        try {
            this.discoverInit(mServer);
        }
        catch (Exception e) {
            throw new WeblogicDiscoverException(e.getMessage(), e);
        }
    }

    private void discoverInit(MBeanServer mServer) throws Exception {
        String scope = "*:Type=ApplicationConfig,*";
        for (ObjectName oName : mServer.queryNames(new ObjectName("*:Type=ApplicationConfig,*"), null)) {
            boolean isInternal;
            String name;
            if (this.domain == null) {
                this.domain = oName.getDomain();
            }
            if (this.adminName == null) {
                this.adminName = oName.getKeyProperty("Location");
            }
            if ((name = oName.getKeyProperty("Name")).equals("console") || !(isInternal = ((Boolean)mServer.getAttribute(oName, "InternalApp")).booleanValue())) continue;
            this.internalApps.put(name, Boolean.TRUE);
        }
    }

    public boolean isInternalApp(String name) {
        return this.internalApps.get(name) == Boolean.TRUE;
    }

    public WeblogicQuery[] getServiceQueries() {
        return this.SERVICE_QUERIES;
    }
}

