/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.exchange;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.mssql.PDH;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.CollectorResult;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricValue;

public class ExchangeCollector
extends Collector {
    private static Log log = LogFactory.getLog(ExchangeCollector.class);
    private List<String> counters = new ArrayList<String>();

    public void collect() {
        log.debug((Object)("[collect] [" + this.getProperties() + "] counters.size() = " + this.counters.size()));
        if (this.counters.size() > 0) {
            try {
                Map<String, Double> res = PDH.getFormattedValues(this.counters);
                for (Map.Entry<String, Double> entry : res.entrySet()) {
                    String obj = entry.getKey();
                    Double val = entry.getValue();
                    log.debug((Object)("[collect] " + obj + " = " + val));
                    this.setValue(obj, val);
                }
            }
            catch (Exception ex) {
                log.debug((Object)("[collect] " + ex), (Throwable)ex);
            }
        }
    }

    public MetricValue getValue(Metric metric, CollectorResult result) {
        log.debug((Object)("[getValue] metirc = " + metric));
        String g = metric.getObjectProperty("g");
        String obj = "\\" + g + "\\" + metric.getAttributeName();
        MetricValue res = MetricValue.NONE;
        if (obj != null) {
            if (this.counters.contains(obj)) {
                res = result.getMetricValue(obj);
            } else {
                this.counters.add(obj);
            }
        }
        log.debug((Object)("[getValue] obj:'" + obj + "' res:'" + res.getValue() + "'"));
        return res;
    }
}

