/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.exchange;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.exchange.ExchangeDagDetector;
import org.hyperic.hq.plugin.exchange.ExchangeUtils;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeDetector
extends ServerDetector
implements AutoServerDetector {
    private static final String IMAP4_NAME = "IMAP4";
    private static final String POP3_NAME = "POP3";
    private static final String MTA_NAME = "MTA";
    private static final String WEB_NAME = "Web";
    private static final String EXCHANGE_KEY = "SOFTWARE\\Microsoft\\Exchange\\Setup";
    static final String EX = "MSExchange";
    private static final String WEBMAIL = "MSExchange Web Mail";
    private static final String EXCHANGE_IS = "MSExchangeIS";
    private static final Log log = LogFactory.getLog((String)ExchangeDetector.class.getName());

    private boolean isExchangeServiceRunning(String name) {
        if (name.equals(MTA_NAME)) {
            return this.isWin32ServiceRunning("MSExchangeMTA");
        }
        return this.isWin32ServiceRunning(name + "Svc") || this.isWin32ServiceRunning(EX + name);
    }

    private ServiceResource createService(String name) {
        String svcName = name;
        svcName = name.equals(MTA_NAME) ? "MSExchangeMTA" : (this.isWin32ServiceRunning(name + "Svc") ? name + "Svc" : (this.isWin32ServiceRunning(EX + name) ? EX + name : EX + name));
        ConfigResponse cfg = new ConfigResponse();
        cfg.setValue("service_name", svcName);
        ServiceResource service = new ServiceResource();
        service.setType((GenericPlugin)this, name);
        service.setServiceName(name);
        this.setProductConfig(service, new ConfigResponse());
        this.setMeasurementConfig(service, new ConfigResponse());
        this.setControlConfig(service, cfg);
        log.debug((Object)("=" + svcName + "=> " + service.getProductConfig()));
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        String exe;
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        Service exch = null;
        try {
            exch = new Service(EXCHANGE_IS);
            if (exch.getStatus() != 4) {
                log.debug((Object)("[getServerResources] service 'MSExchangeIS' is not RUNNING (status='" + exch.getStatusString() + "')"));
                List list = null;
                return list;
            }
            exe = exch.getConfig().getExe().trim();
        }
        catch (Win32Exception e) {
            log.debug((Object)("[getServerResources] Error getting 'MSExchangeIS' service information " + (Object)((Object)e)), (Throwable)e);
            List list = null;
            return list;
        }
        finally {
            if (exch != null) {
                exch.close();
            }
        }
        File bin = new File(exe).getParentFile();
        String installpath = bin.getParent();
        if (!this.isInstallTypeVersion(bin.getPath())) {
            log.debug((Object)("[getServerResources] exchange on '" + bin + "' is not a " + this.getTypeInfo().getName()));
            return null;
        }
        ServerResource server = this.createServerResource(installpath);
        ConfigResponse cprops = new ConfigResponse();
        ConfigResponse productProps = new ConfigResponse();
        String roleRegKeyStr = this.getTypeProperty("EXCHANGE_ROLE_REG_KEY");
        if (roleRegKeyStr != null) {
            String dagName;
            String discoverDAG;
            String adSiteName;
            if (!ExchangeUtils.checkRoleConfiguredAndSetVersion(roleRegKeyStr, cprops)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("role configured  - but not found in registry - ignoring server:" + roleRegKeyStr));
                }
                return null;
            }
            String discoverSite = this.getTypeProperty("SITE_DISCOVERY");
            if (discoverSite != null && (adSiteName = ExchangeUtils.fetchActiveDirectorySiteName()) != null) {
                productProps.setValue("active_directory.site", adSiteName);
            }
            if ((discoverDAG = this.getTypeProperty("DAG_DISCOVERY")) != null && (dagName = ExchangeDagDetector.getDagName(installpath, ExchangeDetector.getPlatformName())) != null) {
                productProps.setValue("DAG_name", dagName);
            }
        } else {
            this.setExchangeVersion(cprops);
        }
        server.setCustomProperties(cprops);
        this.setProductConfig(server, productProps);
        server.setMeasurementConfig();
        servers.add(server);
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExchangeVersion(ConfigResponse cprops) {
        RegistryKey key = null;
        try {
            key = RegistryKey.LocalMachine.openSubKey(EXCHANGE_KEY);
            cprops.setValue("version", key.getStringValue("Services Version"));
            cprops.setValue("build", key.getStringValue("NewestBuild"));
        }
        catch (Win32Exception e) {
            log.debug((Object)e, (Throwable)e);
        }
        finally {
            if (key != null) {
                key.close();
            }
        }
    }

    private List<String> getServicesNames() {
        String roleRegKeyStr = this.getTypeProperty("EXCHANGE_ROLE_REG_KEY");
        if (roleRegKeyStr != null) {
            return Collections.singletonList(MTA_NAME);
        }
        return Arrays.asList(MTA_NAME, POP3_NAME, IMAP4_NAME);
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        ArrayList<ServiceResource> actualServices = new ArrayList<ServiceResource>();
        List<String> servicesNames = this.getServicesNames();
        for (String name : servicesNames) {
            if (!this.isExchangeServiceRunning(name)) {
                log.debug((Object)(name + " is not running"));
                continue;
            }
            log.debug((Object)(name + " is running, adding to inventory"));
            actualServices.add(this.createService(name));
        }
        try {
            String[] web = Pdh.getInstances((String)WEBMAIL);
            if (web.length != 0) {
                actualServices.add(this.createService(WEB_NAME));
            }
        }
        catch (Win32Exception e) {
            log.debug((Object)e, (Throwable)e);
        }
        return actualServices;
    }
}

