/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.plugin.insight.inventory;

import com.hyperic.hq.plugin.insight.config.ServerXmlPropertiesRetriever;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentCommand;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.autoinventory.agent.client.AICommandsUtils;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.jmx.MxServerDetector;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsightServerDetector
extends MxServerDetector {
    private static Map<String, Map<String, String>> signatures = new HashMap<String, Map<String, String>>();
    private final Log log = LogFactory.getLog(InsightServerDetector.class);
    private static final String CATALINA_PROPERTIES_FILE = "/conf/catalina.properties";
    private static final String[] INSIGHT_PROPERTIES_FILE_PATHS = new String[]{"/insight/insight.properties", "/insight/conf/insight.properties", "/insight.properties", "/conf/insight.properties"};
    private static final String HIERARCHY_KEY = "application.hierarchy";
    private static final String SERVER_XML = "/conf/server.xml";
    private static final String CATALINA_BASE = "CATALINA_BASE";

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        List servers = super.getServerResources(platformConfig);
        Iterator it = servers.iterator();
        while (it.hasNext()) {
            ServerResource server = (ServerResource)it.next();
            if (this.isServerType(server)) continue;
            it.remove();
        }
        return servers;
    }

    private boolean isServerType(ServerResource server) {
        boolean propertyExists = false;
        try {
            Properties properties = this.getPropertiesFile(server.getInstallPath(), INSIGHT_PROPERTIES_FILE_PATHS);
            ConfigResponse serverConfig = server.getProductConfig();
            String key = serverConfig.getValue("insight.property.key");
            String val = properties.getProperty(key);
            if (val != null && val.trim().length() > 0) {
                propertyExists = true;
            }
        }
        catch (PluginException e) {
            this.log.error((Object)"Error retrieving info from insight.properties file", (Throwable)e);
        }
        return propertyExists;
    }

    public List<ServiceResource> discoverServices(ConfigResponse serverConfig) throws PluginException {
        List services = super.discoverServices(serverConfig);
        for (ServiceResource s : services) {
            this.discoverResourceHierarchy(s, serverConfig);
        }
        return services;
    }

    public void runAutoDiscovery(ConfigResponse cf) {
        this.getLog().debug((Object)"[runAutoDiscovery] >> start");
        try {
            AgentRemoteValue configARV = AICommandsUtils.createArgForRuntimeDiscoveryConfig((int)0, (int)0, (String)"spring-insight", null, (ConfigResponse)cf);
            this.getLog().debug((Object)("[runAutoDiscovery] configARV=" + configARV));
            AgentCommand ac = new AgentCommand(1, 1, "autoinv:pushRuntimeDiscoveryConfig", configARV);
            AgentDaemon.getMainInstance().getCommandDispatcher().processRequest(ac, null, null);
            this.getLog().debug((Object)"[runAutoDiscovery] << OK");
        }
        catch (Exception ex) {
            this.getLog().debug((Object)("[runAutoDiscovery]" + ex.getMessage()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverResourceHierarchy(ServiceResource service, ConfigResponse serverConfig) {
        JSONObject jsonConfig = new JSONObject();
        String serviceName = service.getName();
        try {
            serviceName = serviceName.split("\"")[1];
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)serverConfig.toProperties());
            jsonConfig.put("applicationServer", (Object)this.getApplicationServers(mServer, serviceName));
            jsonConfig.put("databaseServer", (Object)this.getDatabaseServers(mServer, serviceName));
            jsonConfig.put("createTs", System.currentTimeMillis());
            ConfigResponse productConfig = service.getProductConfig();
            productConfig.setValue(HIERARCHY_KEY, jsonConfig.toString());
            service.setProductConfig(productConfig);
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot discover resource hierarchy for " + service.getName()), (Throwable)e);
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(serviceName + " application.hierarchy=" + jsonConfig));
            }
        }
    }

    private JSONArray getApplicationServers(MBeanServerConnection mServer, String applicationName) {
        JSONArray jsonAppServers = new JSONArray();
        try {
            JSONObject jsonAppServer = new JSONObject();
            JSONArray configInstallPaths = new JSONArray();
            HashSet<String> installPaths = new HashSet<String>();
            String appServerQueryName = "insight:Application=\"" + applicationName + "\",*,type=Application.Server";
            Set<ObjectName> objNames = mServer.queryNames(new ObjectName(appServerQueryName), null);
            for (ObjectName o : objNames) {
                try {
                    String serverName = o.getKeyProperty("Server");
                    if (serverName == null || serverName.trim().length() <= 2) continue;
                    String queryName = "insight:name=" + serverName + ",type=Server";
                    Set<ObjectName> serverObjs = mServer.queryNames(new ObjectName(queryName), null);
                    for (ObjectName s : serverObjs) {
                        String installPath = this.getServerInstallPath(mServer, s);
                        if (installPath == null) continue;
                        installPaths.add(installPath);
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)"Error getting application servers", (Throwable)e);
                }
            }
            for (String path : installPaths) {
                configInstallPaths.put((Object)path);
            }
            jsonAppServer.put("rid", (Object)new JSONArray());
            jsonAppServer.put("installPath", (Object)configInstallPaths);
            jsonAppServers.put((Object)jsonAppServer);
        }
        catch (Exception e) {
            this.log.debug((Object)("Cannot get application servers for " + applicationName), (Throwable)e);
        }
        return jsonAppServers;
    }

    private String getServerInstallPath(MBeanServerConnection mServer, ObjectName s) {
        String installPath;
        block3: {
            installPath = null;
            try {
                CompositeData[] propertiesValues;
                Object propertiesObj = mServer.getAttribute(s, "Properties");
                if (!(propertiesObj instanceof CompositeData[])) break block3;
                for (CompositeData prop : propertiesValues = (CompositeData[])propertiesObj) {
                    String name;
                    if (!prop.containsKey("name") || !prop.containsKey("value") || !CATALINA_BASE.equals(name = (String)prop.get("name"))) continue;
                    installPath = (String)prop.get("value");
                    break;
                }
            }
            catch (Exception e) {
                this.log.debug((Object)"Cannot get server install path", (Throwable)e);
            }
        }
        return installPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray getDatabaseServers(MBeanServerConnection mServer, String applicationName) {
        JSONArray jsonDbServers = new JSONArray();
        Set<ObjectName> dbObjNames = null;
        try {
            JSONObject jsonDbServer = new JSONObject();
            JSONArray configJdbcUrls = new JSONArray();
            JSONArray configHosts = new JSONArray();
            HashSet<String> jdbcUrls = new HashSet<String>();
            String dbServerQueryName = "insight:type=Application.Server.External,*,sub-type=\"DATABASE\"";
            dbObjNames = mServer.queryNames(new ObjectName(dbServerQueryName), null);
            for (ObjectName o : dbObjNames) {
                String jdbcUrl;
                String applicationValue = o.getKeyProperty("Application");
                if (applicationValue == null || !applicationValue.equals("\"" + applicationName + "\"") || (jdbcUrl = (String)mServer.getAttribute(o, "Label")) == null || jdbcUrl.trim().length() <= 0) continue;
                JSONObject config = new JSONObject();
                config.put("hash", (Object)jdbcUrl);
                String hostValue = o.getKeyProperty("ExternalHost");
                String portValue = o.getKeyProperty("ExternalPort");
                if (hostValue != null && portValue != null) {
                    config.put("host", (Object)(hostValue.split("\"")[1] + ":" + portValue.split("\"")[1]));
                }
                jdbcUrls.add(config.toString());
            }
            for (String url : jdbcUrls) {
                configJdbcUrls.put((Object)new JSONObject(url));
            }
            jsonDbServer.put("rid", (Object)new JSONArray());
            jsonDbServer.put("config", (Object)configJdbcUrls);
            jsonDbServers.put((Object)jsonDbServer);
        }
        catch (Exception e) {
            try {
                this.log.debug((Object)("Cannot get database servers for " + applicationName), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("getDatabaseServers: query size=" + (dbObjNames == null ? 0 : dbObjNames.size())));
                }
                throw throwable;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getDatabaseServers: query size=" + (dbObjNames == null ? 0 : dbObjNames.size())));
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getDatabaseServers: query size=" + (dbObjNames == null ? 0 : dbObjNames.size())));
        }
        return jsonDbServers;
    }

    private String getVersion(String warFile) {
        File application = new File(warFile);
        Calendar currentTimestamp = Calendar.getInstance();
        currentTimestamp.setTimeInMillis(application.lastModified());
        long currentfileSize = application.length();
        return null;
    }

    protected void discoverServerConfig(ServerResource server, long pid) {
        this.getLog().debug((Object)("[discoverServerConfig] pid=" + pid + ", server=" + server));
        super.discoverServerConfig(server, pid);
        String nodeName = this.getInstanceNameFromPath(server.getInstallPath());
        String nodePort = this.getHttpConnectorPort(server.getInstallPath());
        server.setName(server.getName() + " " + nodeName);
        server.setIdentifier(nodeName + "-" + server.getInstallPath());
        ConfigResponse serverConfig = server.getProductConfig();
        serverConfig.setValue("jmx.password", "springsource");
        serverConfig.setValue("catalina.base", server.getInstallPath());
        serverConfig.setValue("insight.node.name", nodeName);
        server.setProductConfig(serverConfig);
        if (nodePort != null) {
            ConfigResponse custom = new ConfigResponse();
            custom.setValue("node.port", nodePort);
            server.setCustomProperties(custom);
        }
        try {
            List<ServiceResource> services = this.discoverServices(serverConfig);
            HashMap<String, String> new_signature = new HashMap<String, String>();
            for (ServiceResource s : services) {
                String hierarchyString = null;
                try {
                    hierarchyString = s.getProductConfig().getValue(HIERARCHY_KEY);
                }
                catch (Exception e) {
                    this.log.debug((Object)"Could not get application.hierarchy", (Throwable)e);
                }
                new_signature.put(s.getName(), hierarchyString);
            }
            Map<String, String> signature = signatures.get(nodeName);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("     nodeName=" + nodeName));
                this.log.debug((Object)("new_signature=" + new_signature));
                this.log.debug((Object)("    signature=" + signature));
            }
            if (!((Object)new_signature).equals(signature)) {
                if (signature != null) {
                    this.runAutoDiscovery(server.getProductConfig());
                }
                signatures.put(nodeName, new_signature);
            }
        }
        catch (PluginException ex) {
            this.log.debug((Object)"Could not get new signatures", (Throwable)ex);
        }
    }

    private String getHttpConnectorPort(String basePath) {
        String portValue = null;
        try {
            ServerXmlPropertiesRetriever propertiesRetriever = new ServerXmlPropertiesRetriever();
            Map<String, String> listenerProperties = propertiesRetriever.getPropertiesFromFile(String.valueOf(basePath) + SERVER_XML, "Connector", "protocol", "HTTP/1.1");
            if (listenerProperties.isEmpty()) {
                listenerProperties = propertiesRetriever.getPropertiesFromFile(String.valueOf(basePath) + SERVER_XML, "Connector", "protocol", "org.apache.coyote.http11.Http11Protocol");
            }
            if (!listenerProperties.isEmpty()) {
                portValue = this.getValueFromPropertiesFile(basePath, listenerProperties.get("port"));
            }
        }
        catch (PluginException e) {
            this.log.error((Object)"Error retrieving Connector info from tc Server config file", (Throwable)e);
        }
        return portValue;
    }

    protected String getInstanceNameFromPath(String path) {
        Assert.hasText((String)path, (String)"'path' must not be null.");
        Pattern p = Pattern.compile("([^/\\\\]+)$");
        Matcher m = p.matcher(path);
        return m.find() ? m.group(1) : null;
    }

    protected String getProcQuery(String path) {
        if (path == null) {
            return this.getProcessQuery();
        }
        String processQuery = this.getProcessQuery();
        return processQuery.replace("Args.*.sw=-Dcatalina.base", "Args.*.eq=-Dcatalina.base=" + path);
    }

    protected void setJmxUrl(MxServerDetector.MxProcess process, ConfigResponse config) {
        if (process.getURL() != null) {
            config.setValue("jmx.url", process.getURL());
        } else {
            String[] args = process.getArgs();
            for (int j = 0; j < args.length && !this.configureListenerMxURL(config, this.getCatalinaBase(process.getArgs())) && !this.configureMxURL(config, args[j]); ++j) {
                this.configureLocalMxURL(config, args[j], this.getProcQuery(process.getInstallPath()));
            }
        }
    }

    protected String getCatalinaBase(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-Dcatalina.base=")) continue;
            return arg.substring("-Dcatalina.base=".length());
        }
        return null;
    }

    protected boolean configureListenerMxURL(ConfigResponse config, String basePath) {
        try {
            boolean found = false;
            ServerXmlPropertiesRetriever propertiesRetriever = new ServerXmlPropertiesRetriever();
            Map<String, String> listenerProperties = propertiesRetriever.getPropertiesFromFile(String.valueOf(basePath) + SERVER_XML, "Listener", "className", "com.springsource.tcserver.serviceability.rmi.JmxSocketListener");
            if (!listenerProperties.isEmpty()) {
                String bindAddressValue = this.getValueFromPropertiesFile(basePath, listenerProperties.get("bind"));
                String portValue = this.getValueFromPropertiesFile(basePath, listenerProperties.get("port"));
                config.setValue("jmx.url", "service:jmx:rmi:///jndi/rmi://" + bindAddressValue + ":" + portValue + "/jmxrmi");
                found = true;
            }
            return found;
        }
        catch (PluginException e) {
            this.log.error((Object)"Error retrieving JMX URL from tc Server config file", (Throwable)e);
            return false;
        }
    }

    private String getValueFromPropertiesFile(String basePath, String property) throws PluginException {
        String propertyValue = property;
        if (property.startsWith("${") && property.endsWith("}")) {
            String propertyKey = property.substring(2, property.length() - 1);
            Properties properties = this.getPropertiesFile(basePath, CATALINA_PROPERTIES_FILE);
            propertyValue = properties.getProperty(propertyKey);
        }
        return propertyValue;
    }

    private Properties getPropertiesFile(String serverHome, String ... arrFileRelativePaths) throws PluginException {
        Properties properties = new Properties();
        File propsFile = null;
        File serverHomeFile = new File(serverHome);
        for (String filePath : arrFileRelativePaths) {
            try {
                propsFile = new File(serverHomeFile, filePath);
                if (propsFile.exists()) {
                    properties.load(new FileInputStream(propsFile));
                    return properties;
                }
                this.log.info((Object)("Spring Insight properties file does not exist at: '" + propsFile + "'"));
            }
            catch (FileNotFoundException e) {
                this.log.warn((Object)("Unable to find a Spring Insight property file at: " + propsFile), (Throwable)e);
            }
            catch (IOException e) {
                this.log.warn((Object)("An Error had occured while trying to load a Spring Insight properties file: " + propsFile), (Throwable)e);
            }
        }
        throw new PluginException("Unable to find a Spring Insight property file under '" + serverHome + "' and the following paths(s): " + Arrays.toString(arrFileRelativePaths));
    }
}

