/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import com.ibm.websphere.management.AdminClient;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.websphere.WebsphereCollector;
import org.hyperic.hq.product.PluginException;

public class WebappCollector
extends WebsphereCollector {
    private static final Log log = LogFactory.getLog((String)WebappCollector.class.getName());
    private ObjectName sessionStatsObjectName = null;
    private static final String[] sessionStatNames = new String[]{"CreateCount", "InvalidateCount", "LifeTime", "ActiveCount", "LiveCount", "NoRoomForNewSessionCount", "CacheDiscardCount", "ExternalReadTime", "ExternalReadSize", "ExternalWriteTime", "ExternalWriteSize", "AffinityBreakCount", "TimeSinceLastActivated", "TimeoutInvalidationCount", "ActivateNonExistSessionCount", "SessionObjectSize"};

    protected void init(AdminClient mServer) throws PluginException {
        String module = this.getModuleName();
        int ix = module.indexOf(35);
        if (ix == -1) {
            throw new PluginException("Malformed webapp name '" + module + "'");
        }
        String app = module.substring(0, ix);
        String war = module.substring(ix + 1);
        ObjectName name = this.newObjectNamePattern("j2eeType=WebModule,J2EEApplication=" + app + "," + "name=" + war + "," + this.getProcessAttributes());
        this.setObjectName(this.resolve(mServer, name));
        name = this.newObjectNamePattern("name=" + this.getModuleName() + "," + "type=SessionManager," + this.getProcessAttributes());
        try {
            this.sessionStatsObjectName = this.resolve(mServer, name);
        }
        catch (PluginException e) {
            log.debug((Object)"Can't resolve session stats object name. Not collecting session statistics.");
        }
    }

    public void collect(AdminClient mServer) throws PluginException {
        Object servlets = this.getAttribute(mServer, this.getObjectName(), "servlets");
        if (servlets == null) {
            this.setAvailability(false);
        } else {
            Stats stats;
            this.setAvailability(true);
            if (this.sessionStatsObjectName == null) {
                this.init(mServer);
            }
            if ((stats = this.getStats(mServer, this.sessionStatsObjectName)) != null) {
                for (int i = 0; i < sessionStatNames.length; ++i) {
                    this.setValue(sessionStatNames[i], this.getStatCount(stats, sessionStatNames[i]));
                }
            } else {
                log.debug((Object)"No session manager stats");
            }
        }
    }
}

