/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.websphere.WebsphereStopWatch;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;

public class WebsphereUtil {
    private static HashMap cache = new HashMap();
    private static Log log = LogFactory.getLog((String)"WebSphereUtil");
    private static final String TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String KEY_STORE = "javax.net.ssl.keyStore";
    private static final String TRUST_STORE_PWD = "javax.net.ssl.trustStorePassword";
    private static final String KEY_STORE_PWD = "javax.net.ssl.keyStorePassword";
    private static final HashMap beans = new HashMap();

    public static Object getRemoteMBeanValue(Metric metric) throws MetricNotFoundException, MetricUnreachableException, PluginException {
        return WebsphereUtil.getRemoteMBeanValue(metric, metric.getAttributeName());
    }

    public static Object getRemoteMBeanValue(Metric metric, String attributeName) throws MetricNotFoundException, MetricUnreachableException, PluginException {
        ObjectName objName;
        AdminClient mServer = WebsphereUtil.getMBeanServer(metric);
        try {
            objName = new ObjectName(metric.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            throw new MetricInvalidException(e.getMessage(), (Throwable)e);
        }
        try {
            return mServer.getAttribute(objName, metric.getAttributeName());
        }
        catch (MBeanException e) {
            String msg = "MBeanException: " + e.getMessage();
            throw new PluginException(msg, (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            String msg = "Attribute '" + attributeName + "' " + "not found for '" + objName + "'";
            throw new MetricNotFoundException(msg, (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            String msg = "MBean '" + objName + "' not found";
            throw new MetricNotFoundException(msg, (Throwable)e);
        }
        catch (ReflectionException e) {
            String msg = "ReflectionException: " + e.getMessage();
            throw new PluginException(msg, (Throwable)e);
        }
        catch (ConnectorException e) {
            String msg = "ConnectorException: " + e.getMessage();
            throw new PluginException(msg, (Throwable)e);
        }
    }

    public static AdminClient getMBeanServer(Properties cfg) throws MetricUnreachableException {
        AdminClient mServer;
        Properties props = WebsphereUtil.getAdminProperties(cfg);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to create admin client with props " + props + " from config " + cfg));
        }
        WebsphereStopWatch timer = new WebsphereStopWatch();
        try {
            mServer = AdminClientFactory.createAdminClient((Properties)props);
        }
        catch (LinkageError e) {
            log.error((Object)"Incorrect JVM ??? !!!", (Throwable)e);
            throw new MetricUnreachableException(e.getMessage(), (Throwable)e);
        }
        catch (ConnectorException ex) {
            Throwable e = ex;
            while ((e = e.getCause()) != null) {
                if (!(e instanceof LinkageError)) continue;
                throw new MetricUnreachableException("!!! Incorrect JVM !!!", e);
            }
            throw new MetricUnreachableException(ex.getMessage(), (Throwable)ex);
        }
        if (log.isDebugEnabled() && timer.isTooLong()) {
            log.debug((Object)("createAdminClient took: " + timer.getElapsedSeconds() + " seconds"));
        }
        return mServer;
    }

    public static Properties getAdminProperties(Properties cfg) {
        log.debug((Object)("[getAdminProperties] cfg=" + cfg));
        String host = cfg.getProperty("admin.host", "localhost");
        String port = cfg.getProperty("admin.port", "8880");
        Properties props = new Properties();
        props.setProperty("type", "SOAP");
        props.setProperty("host", host);
        props.setProperty("port", port);
        String user = cfg.getProperty("username", "");
        String pass = cfg.getProperty("password", "");
        if (!user.equals("") && !pass.equals("")) {
            props.setProperty("username", user);
            props.setProperty("password", pass);
            props.setProperty("securityEnabled", "true");
            String trustStore = cfg.getProperty(TRUST_STORE);
            String keyStore = cfg.getProperty(KEY_STORE);
            String trustStorePwd = cfg.getProperty(TRUST_STORE_PWD);
            String keyStorePwd = cfg.getProperty(KEY_STORE_PWD);
            if (trustStore != null && keyStore != null && trustStorePwd != null && keyStorePwd != null) {
                props.setProperty(TRUST_STORE, trustStore);
                props.setProperty(KEY_STORE, keyStore);
                props.setProperty(TRUST_STORE_PWD, trustStorePwd);
                props.setProperty(KEY_STORE_PWD, keyStorePwd);
            }
        }
        log.debug((Object)("[getAdminProperties] props=" + props));
        return props;
    }

    public static AdminClient getMBeanServer(Metric metric) throws MetricUnreachableException {
        String key = metric.getPropString();
        AdminClient mServer = (AdminClient)cache.get(key);
        if (mServer != null) {
            try {
                mServer.getDomainName();
            }
            catch (ConnectorException e) {
                mServer = null;
                log.debug((Object)("getMBeanServer stale connection: " + key));
            }
        }
        if (mServer == null) {
            mServer = WebsphereUtil.getMBeanServer(metric.getProperties());
            cache.put(key, mServer);
            log.debug((Object)("getMBeanServer caching: " + key));
        }
        return mServer;
    }

    /*
     * Exception decompiling
     */
    public static double getMBeanCount(AdminClient mServer, ObjectName query, String attr) throws MetricUnreachableException, MetricNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ObjectName resolve(AdminClient mServer, ObjectName name) throws PluginException {
        if (!name.isPattern()) {
            return name;
        }
        try {
            Set beansSet = mServer.queryNames(name, null);
            if (beansSet.size() != 1) {
                String msg = name + " query returned " + beansSet.size() + " results";
                throw new PluginException(msg);
            }
            ObjectName fullName = (ObjectName)beansSet.iterator().next();
            if (log.isDebugEnabled()) {
                log.debug((Object)(name + " resolved to: " + fullName));
            }
            return fullName;
        }
        catch (Exception e) {
            String msg = "resolve(" + name + "): " + e.getMessage();
            throw new PluginException(msg, (Throwable)e);
        }
    }

    public static boolean isRunning(Metric metric) {
        String domain;
        AdminClient mServer;
        try {
            mServer = WebsphereUtil.getMBeanServer(metric);
            domain = mServer.getDomainName();
        }
        catch (MetricUnreachableException e) {
            log.debug((Object)(metric + ": " + (Object)((Object)e)), (Throwable)e);
            return false;
        }
        catch (ConnectorException e) {
            log.debug((Object)(metric + ": " + (Object)((Object)e)), (Throwable)e);
            return false;
        }
        String query = domain + ":" + metric.getObjectPropString() + ",*";
        ObjectName name = (ObjectName)beans.get(query);
        if (name == null) {
            try {
                name = new ObjectName(query);
            }
            catch (MalformedObjectNameException e) {
                throw new MetricInvalidException(metric.getObjectName());
            }
            try {
                name = WebsphereUtil.resolve(mServer, name);
            }
            catch (PluginException e) {
                return false;
            }
            log.debug((Object)("isRunningCache " + query + "-->" + name));
            beans.put(query, name);
            return true;
        }
        try {
            mServer.getMBeanInfo(name);
            return true;
        }
        catch (Exception e) {
            beans.remove(query);
            return false;
        }
    }

    public static Object invoke(String objectName, Properties props, String method, Object[] args, String[] sig) throws PluginException {
        AdminClient mServer;
        try {
            mServer = WebsphereUtil.getMBeanServer(props);
        }
        catch (MetricUnreachableException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        return WebsphereUtil.invoke(mServer, objectName, method, args, sig);
    }

    public static Object invoke(AdminClient mServer, String objectName, String method, Object[] args, String[] sig) throws PluginException {
        ObjectName obj;
        try {
            obj = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new PluginException((Throwable)e);
        }
        try {
            if (obj.isPattern()) {
                obj = WebsphereUtil.resolve(mServer, obj);
            }
            return mServer.invoke(obj, method, args, sig);
        }
        catch (InstanceNotFoundException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        catch (MBeanException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        catch (ConnectorException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }
}

