/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.apache;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.hq.plugin.apache.ApacheBinaryInfo;
import org.hyperic.hq.plugin.apache.ApacheServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.RegistryServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;

public class ErsApacheServerDetector
extends ApacheServerDetector
implements RegistryServerDetector {
    private static final String[] PTQL_QUERIES_20 = new String[]{"State.Name.eq=httpsd.prefork,State.Name.Pne=$1", "State.Name.eq=httpsd.worker,State.Name.Pne=$1"};
    private static final String[] PTQL_QUERIES_13 = new String[]{"State.Name.eq=httpsd,State.Name.Pne=$1"};

    public List getServerList(String installpath, ApacheBinaryInfo binary) throws PluginException {
        this.getLog().debug((Object)("[getServerList] installpath=" + installpath));
        File serversDir = new File(installpath, "servers");
        File[] serverList = serversDir.listFiles();
        if (serverList == null) {
            return null;
        }
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        String type = this.getTypeInfo().getName();
        for (int i = 0; i < serverList.length; ++i) {
            if (!serverList[i].isDirectory()) continue;
            String serverRoot = serverList[i].getAbsolutePath();
            File pidFile = new File(serverRoot, this.getDefaultPidFile());
            if (!pidFile.exists()) {
                this.getLog().debug((Object)("[getServerList] pidFile (" + pidFile + ") not found."));
                continue;
            }
            String serverName = serverList[i].getName();
            ServerResource server = this.createServerResource(serverRoot);
            String name = server.getName();
            if (!name.equals(serverName + " " + type)) {
                server.setName(name + " (" + serverName + ")");
            }
            server.setIdentifier(this.getAIID(serverRoot));
            if (this.configureServer(server, binary)) {
                if (ErsApacheServerDetector.isWin32()) {
                    ConfigResponse cf = new ConfigResponse();
                    String sname = this.getWindowsServiceName(serverName);
                    if (sname != null) {
                        cf.setValue("service_name", sname);
                        this.setControlConfig(server, cf);
                    }
                }
                this.getLog().debug((Object)("[getServerList] serverRoot=" + serverRoot + " serverName=" + serverName + " OK"));
                servers.add(server);
                continue;
            }
            this.getLog().debug((Object)("[getServerList] serverRoot=" + serverRoot + " serverName=" + serverName + " no configured"));
        }
        return servers;
    }

    protected String getWindowsServiceName() {
        return null;
    }

    protected String getWindowsServiceName(String serverName) {
        String name = "ERS" + serverName + "httpsd";
        try {
            List services = Service.getServiceNames();
            if (!services.contains(name) && !services.contains(name = "Covalent" + ErsApacheServerDetector.getPlatformName() + "ApacheERS" + this.getTypeInfo().getVersion())) {
                name = null;
            }
        }
        catch (Win32Exception ex) {
            this.getLog().debug((Object)("[getWindowsServiceName] " + ex.getMessage()), (Throwable)ex);
            name = null;
        }
        this.getLog().debug((Object)("[getWindowsServiceName] name=" + name));
        return name;
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        if (ErsApacheServerDetector.isWin32()) {
            return null;
        }
        ArrayList servers = new ArrayList();
        List binaries = new ArrayList();
        String version = this.getTypeInfo().getVersion();
        if (version.equals("4.x")) {
            binaries.addAll(this.getServerProcessList("2.2", PTQL_QUERIES_20));
        } else if (version.equals("3.x")) {
            binaries.addAll(this.getServerProcessList("2.0", PTQL_QUERIES_20));
            List binaries_13 = this.getServerProcessList("1.3", PTQL_QUERIES_13);
            if (binaries_13 != null) {
                if (binaries == null) {
                    binaries = binaries_13;
                } else {
                    binaries.addAll(binaries_13);
                }
            }
        }
        String versionFile = this.getTypeProperty("VERSION_FILE");
        if (versionFile == null) {
            return null;
        }
        for (int i = 0; i < binaries.size(); ++i) {
            List found;
            ApacheBinaryInfo info = (ApacheBinaryInfo)binaries.get(i);
            String path = ErsApacheServerDetector.getParentDir((String)info.binary, (int)3);
            if (!new File(path, versionFile).exists() || (found = this.getServerList(path, info)) == null) continue;
            servers.addAll(found);
        }
        return servers;
    }

    public List getServerResources(ConfigResponse platformConfig, String path) throws PluginException {
        String version = this.getTypeInfo().getVersion();
        ApacheBinaryInfo binary = ApacheBinaryInfo.getInfo(path);
        if (binary == null || binary.version == null) {
            this.getLog().debug((Object)("[getServerResources] no Binary Info path=" + path + " version=" + version));
            return null;
        }
        if (version.equals("4.x") && !binary.version.startsWith("2.2")) {
            this.getLog().debug((Object)("[getServerResources] Binary Info path=" + path + " version=" + version + " no ERS4.x"));
            return null;
        }
        if (version.equals("3.x") && !binary.version.startsWith("2.0")) {
            this.getLog().debug((Object)("[getServerResources] Binary Info path=" + path + " version=" + version + " no ERS4.x"));
            return null;
        }
        this.getLog().debug((Object)("[getServerResources] Binary Info path=" + path + " version=" + version + " IS ERS =" + version));
        return this.getServerList(ErsApacheServerDetector.getParentDir((String)binary.binary, (int)3), binary);
    }

    public List getServerResources(ConfigResponse platformConfig, String path, RegistryKey current) throws PluginException {
        return this.getServerResources(platformConfig, path);
    }

    private String getAIID(String serverRoot) {
        return "ERS-Apache " + serverRoot;
    }
}

