/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq;

import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.wsmq.cmd.InquireAliasQueue;
import org.hyperic.hq.plugin.wsmq.cmd.InquireChannel;
import org.hyperic.hq.plugin.wsmq.cmd.InquireCluster;
import org.hyperic.hq.plugin.wsmq.cmd.InquireClusterReceiverChannel;
import org.hyperic.hq.plugin.wsmq.cmd.InquireDefault;
import org.hyperic.hq.plugin.wsmq.cmd.InquireLocalQueue;
import org.hyperic.hq.plugin.wsmq.cmd.InquireQManager;
import org.hyperic.hq.plugin.wsmq.cmd.InquireRemoteQueue;
import org.hyperic.hq.plugin.wsmq.cmd.InquireTopic;
import org.hyperic.hq.plugin.wsmq.cmd.InquireTopicPUB;
import org.hyperic.hq.plugin.wsmq.cmd.InquireTopicSUB;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;

public class MQSeriesCmdHandler {
    private Log log = LogFactory.getLog(MQSeriesCmdHandler.class);
    private HashMap cmds = new HashMap();
    private static MQSeriesCmdHandler instance = null;

    public static MQSeriesCmdHandler getInstance() {
        if (instance == null) {
            instance = new MQSeriesCmdHandler();
        }
        return instance;
    }

    public MQSeriesCmdHandler() {
        this.cmds.put("mqseries-mgr", new InquireQManager());
        this.cmds.put("mqseries-queue", new InquireLocalQueue());
        this.cmds.put("mqseries-a_queue", new InquireAliasQueue());
        this.cmds.put("mqseries-r_queue", new InquireRemoteQueue());
        this.cmds.put("mqseries-channel", new InquireChannel());
        this.cmds.put("mqseries-rc_channel", new InquireClusterReceiverChannel());
        this.cmds.put("mqseries-topic", new InquireTopic());
        this.cmds.put("mqseries-topic-sub", new InquireTopicSUB());
        this.cmds.put("mqseries-topic-pub", new InquireTopicPUB());
        this.cmds.put("mqseries-cluster", new InquireCluster());
    }

    public Double getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        Properties props = metric.getObjectProperties();
        String mgr = props.getProperty("Mgr");
        String domain = metric.getDomainName();
        InquireDefault cmd = (InquireDefault)this.cmds.get(domain);
        assert (cmd != null) : "No command for '" + domain + "'";
        if (cmd == null) {
            throw new PluginException("No command for '" + domain + "'");
        }
        this.log.debug((Object)("cmd='" + cmd.getClass().getName() + "' mgr='" + mgr + "' domain='" + domain + "'"));
        if (mgr == null) {
            throw new MetricInvalidException("Missing 'Mgr' Attribute");
        }
        if (cmd == null) {
            throw new MetricInvalidException("No such command: " + domain);
        }
        return cmd.getValue(metric);
    }
}

