/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq.control;

import com.ibm.mq.MQException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import java.io.IOException;
import java.util.Arrays;
import org.hyperic.hq.plugin.wsmq.MQSeriesProductPlugin;
import org.hyperic.hq.plugin.wsmq.control.DefaulControl;
import org.hyperic.hq.product.PluginException;

public class MQCommands {
    public static void channelPing(DefaulControl control) {
        MQCommands.doMQCommand(control, MQCommands.getChannelMsg(control, 26), "Ping OK");
    }

    public static void channelStop(DefaulControl control) {
        MQCommands.doMQCommand(control, MQCommands.getChannelMsg(control, 29), "Channel stopped");
    }

    public static void channelStart(DefaulControl control) {
        MQCommands.doMQCommand(control, MQCommands.getChannelMsg(control, 28), "Channel started");
    }

    public static void clusterRefreshCluster(DefaulControl control) {
        MQCommands.doMQCommand(control, MQCommands.getClusterMsg(control, 73), "Cluster Refreshed");
    }

    public static void clusterResetCluster(DefaulControl control) {
        String qManager = control.getConfig("queue.manager.name");
        control.debug("qManager='" + qManager + "'");
        PCFMessage msg = MQCommands.getClusterMsg(control, 74);
        msg.addParameter(2015, qManager);
        msg.addParameter(1086, 1);
        MQCommands.doMQCommand(control, msg, "Cluster Reset");
    }

    public static void clusterResumeQueueManagerCluster(DefaulControl control) {
        PCFMessage msg = MQCommands.getClusterMsg(control, 71);
        MQCommands.doMQCommand(control, msg, "Cluster Resumed");
    }

    public static void clusterSuspendQueueManagerCluster(DefaulControl control) {
        PCFMessage msg = MQCommands.getClusterMsg(control, 72);
        MQCommands.doMQCommand(control, msg, "Cluster Suspended");
    }

    private static PCFMessage getClusterMsg(DefaulControl control, int cmd) {
        String cluster = control.getConfig("cluster.name");
        control.debug("cluster='" + cluster + "'");
        PCFMessage msg = new PCFMessage(cmd);
        msg.addParameter(2029, cluster);
        return msg;
    }

    private static PCFMessage getChannelMsg(DefaulControl control, int cmd) {
        String channel = control.getConfig("channel.name");
        control.debug("channel='" + channel + "'");
        PCFMessage msg = new PCFMessage(cmd);
        msg.addParameter(3501, channel);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doMQCommand(DefaulControl control, PCFMessage msg, String okMsg) {
        String qManager = control.getConfig("queue.manager.name");
        control.debug("qManager='" + qManager + "'");
        control.debug("config=" + control.getConfig());
        PCFMessageAgent agent = null;
        try {
            agent = new PCFMessageAgent(qManager);
            PCFMessage[] responses = agent.send(msg);
            if (MQSeriesProductPlugin.isTraceEnabled()) {
                control.debug("responses = " + Arrays.asList(responses));
            }
            assert (responses.length == 1) : responses;
            if (responses[0].getReason() == 0) {
                control.setMessage(okMsg);
                control.setResult(0);
            } else {
                MQCommands.processResponse(control, responses[0]);
            }
        }
        catch (MQException ex) {
            MQCommands.processPCFException(control, ex);
        }
        catch (IOException ex) {
            new PluginException((Throwable)ex);
        }
        finally {
            if (agent != null) {
                try {
                    agent.disconnect();
                }
                catch (MQException e) {
                    control.debug("agent.disconnect() : " + e.getMessage());
                }
            }
        }
    }

    private static void processResponse(DefaulControl control, PCFMessage pCFMessage) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private static void processPCFException(DefaulControl control, MQException ex) {
        MQCommands.processReasonCode(control, ex.reasonCode, ex.getMessage());
    }

    private static void processReasonCode(DefaulControl control, int reason, String alt) {
        String msg = control.getProperties().getProperty("control." + control.getServiceType() + "." + reason);
        if (msg == null) {
            msg = control.getProperties().getProperty("control." + reason);
        }
        assert (msg != null) : alt;
        if (msg == null) {
            msg = alt;
        }
        if (msg == null) {
            throw new UnsupportedOperationException("reason=" + reason);
        }
        control.setMessage(msg);
        control.setResult(-1);
    }
}

