/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Vector;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;

public class OracleRow
implements Serializable,
Cloneable {
    private Object[] column;
    private Object[] changedColumn;
    private boolean[] isOriginalNull;
    private byte[] columnChangeFlag;
    private int noColumn = 0;
    private int noColumnsInserted;
    private boolean rowDeleted = false;
    private boolean rowInserted = false;
    private static final byte COLUMN_CHANGED = 17;
    private boolean rowUpdated = false;
    int[][] columnTypeInfo;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_12:16:40_PDT_2010";
    public static final boolean TRACE = false;

    public OracleRow(int n2) {
        this.noColumn = n2;
        this.column = new Object[n2];
        this.changedColumn = new Object[n2];
        this.columnChangeFlag = new byte[n2];
        this.isOriginalNull = new boolean[n2];
        this.columnTypeInfo = new int[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.columnChangeFlag[i2] = 0;
        }
    }

    public OracleRow(int n2, boolean bl) {
        this(n2);
        this.rowInserted = bl;
        this.noColumnsInserted = 0;
    }

    public OracleRow(int n2, Object[] objectArray) {
        this(n2);
        System.arraycopy(objectArray, 0, this.column, 0, n2);
    }

    public void setColumnValue(int n2, Object object) {
        if (this.rowInserted) {
            ++this.noColumnsInserted;
        }
        this.column[n2 - 1] = object;
    }

    void markOriginalNull(int n2, boolean bl) throws SQLException {
        this.isOriginalNull[n2 - 1] = bl;
    }

    boolean isOriginalNull(int n2) throws SQLException {
        return this.isOriginalNull[n2 - 1];
    }

    public void updateObject(int n2, Object object) {
        this.updateObject(n2, object, null);
    }

    void updateObject(int n2, Object object, int[] nArray) {
        if (this.rowInserted) {
            ++this.noColumnsInserted;
        }
        this.columnChangeFlag[n2 - 1] = 17;
        this.changedColumn[n2 - 1] = object;
        this.columnTypeInfo[n2 - 1] = nArray;
    }

    public void cancelRowUpdates() {
        this.noColumnsInserted = 0;
        for (int i2 = 0; i2 < this.noColumn; ++i2) {
            this.columnChangeFlag[i2] = 0;
        }
        this.changedColumn = null;
        this.changedColumn = new Object[this.noColumn];
    }

    public Object getColumn(int n2) {
        return this.column[n2 - 1];
    }

    public Object getModifiedColumn(int n2) {
        return this.changedColumn[n2 - 1];
    }

    public boolean isColumnChanged(int n2) {
        return this.columnChangeFlag[n2 - 1] == 17;
    }

    public boolean isRowUpdated() {
        if (this.rowInserted || this.rowDeleted) {
            return false;
        }
        for (int i2 = 0; i2 < this.noColumn; ++i2) {
            if (this.columnChangeFlag[i2] != 17) continue;
            return true;
        }
        return false;
    }

    public void setRowUpdated(boolean bl) {
        this.rowUpdated = bl;
        if (!bl) {
            this.cancelRowUpdates();
        }
    }

    public boolean isRowInserted() {
        return this.rowInserted;
    }

    public void cancelRowDeletion() {
        this.rowDeleted = false;
    }

    public void setRowDeleted(boolean bl) {
        this.rowDeleted = bl;
    }

    public boolean isRowDeleted() {
        return this.rowDeleted;
    }

    public Object[] getOriginalRow() {
        return this.column;
    }

    public boolean isRowFullyPopulated() {
        if (!this.rowInserted) {
            return false;
        }
        return this.noColumnsInserted == this.noColumn;
    }

    public void setInsertedFlag(boolean bl) {
        this.rowInserted = bl;
    }

    void makeUpdatesOriginal() {
        for (int i2 = 0; i2 < this.noColumn; ++i2) {
            if (this.columnChangeFlag[i2] != 17) continue;
            this.column[i2] = this.changedColumn[i2];
            this.changedColumn[i2] = null;
            this.columnChangeFlag[i2] = 0;
        }
        this.rowUpdated = false;
    }

    public void insertRow() {
        this.columnChangeFlag = null;
        this.columnChangeFlag = new byte[this.noColumn];
        System.arraycopy(this.changedColumn, 0, this.column, 0, this.noColumn);
        this.changedColumn = null;
        this.changedColumn = new Object[this.noColumn];
    }

    public Collection toCollection() {
        Vector<Object> vector = new Vector<Object>(this.noColumn);
        for (int i2 = 1; i2 <= this.noColumn; ++i2) {
            vector.add(this.isColumnChanged(i2) ? this.getModifiedColumn(i2) : this.getColumn(i2));
        }
        return vector;
    }

    public OracleRow createCopy() throws SQLException {
        OracleRow oracleRow = new OracleRow(this.noColumn);
        for (int i2 = 0; i2 < this.noColumn; ++i2) {
            oracleRow.column[i2] = this.getCopy(this.column[i2]);
            oracleRow.changedColumn[i2] = this.getCopy(this.changedColumn[i2]);
        }
        System.arraycopy(this.columnChangeFlag, 0, oracleRow.columnChangeFlag, 0, this.noColumn);
        oracleRow.noColumnsInserted = this.noColumnsInserted;
        oracleRow.rowDeleted = this.rowDeleted;
        oracleRow.rowInserted = this.rowInserted;
        oracleRow.rowUpdated = this.rowUpdated;
        return oracleRow;
    }

    public Object getCopy(Object object) throws SQLException {
        Object object2;
        block9: {
            object2 = null;
            try {
                if (object == null) {
                    return null;
                }
                if (object instanceof String) {
                    object2 = (String)object;
                    break block9;
                }
                if (object instanceof Number) {
                    object2 = new BigDecimal(((Number)object).toString());
                    break block9;
                }
                if (object instanceof Date) {
                    object2 = new Date(((Date)object).getTime());
                    break block9;
                }
                if (object instanceof Timestamp) {
                    object2 = new Timestamp(((Timestamp)object).getTime());
                    break block9;
                }
                if (object instanceof InputStream) {
                    object2 = new DataInputStream((InputStream)object);
                    break block9;
                }
                if (object instanceof OutputStream) {
                    object2 = new DataOutputStream((OutputStream)object);
                    break block9;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 348, object.getClass().getName());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (Exception exception) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 349, object.getClass().getName() + exception.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return object2;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return this.createCopy();
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException("Error while cloning\n" + sQLException.getMessage());
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

