/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.appha;

import org.hyperic.hq.plugin.appha.VSphereUtil;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;

public class VCenterMeasurementPlugin
extends MeasurementPlugin {
    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        VSphereUtil vim = null;
        try {
            long start = System.currentTimeMillis();
            vim = VSphereUtil.getInstance(metric.getObjectProperties());
            if (!vim.isSessionValid()) {
                throw new MetricUnreachableException("Cannot validate connection properties");
            }
            if (metric.getAttributeName().equals("ConnectionValidationTime")) {
                MetricValue metricValue = new MetricValue(System.currentTimeMillis() - start);
                return metricValue;
            }
        }
        catch (PluginException e) {
            if (metric.isAvail()) {
                MetricValue metricValue = new MetricValue(0.0);
                return metricValue;
            }
            throw new MetricUnreachableException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (vim != null) {
                VSphereUtil.dispose(vim);
            }
        }
        return new MetricValue(1.0);
    }
}

