/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.openldap;

import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeSet;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;

public class OpenLDAPMeasurementPlugin
extends MeasurementPlugin {
    private DirContext ctx = null;
    private boolean hasMonitoringEnabled = false;
    private final Log log = this.getLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirContext getDirContext(Properties props) throws NamingException {
        if (this.ctx == null) {
            OpenLDAPMeasurementPlugin openLDAPMeasurementPlugin = this;
            synchronized (openLDAPMeasurementPlugin) {
                if (this.ctx == null) {
                    this.log.debug((Object)"[getDirContext] creating new connection");
                    TreeSet rtn = new TreeSet();
                    Hashtable<String, String> ldapEnv = new Hashtable<String, String>();
                    String ldapDriver = props.getProperty("ldapDriver");
                    String ldapHostURL = props.getProperty("ldapHostURL");
                    String ldapAuthType = props.getProperty("ldapAuthType");
                    String ldapPasswd = props.getProperty("ldapPasswd");
                    String ldapTreePathToDN = props.getProperty("ldapTreePathToDN");
                    ldapTreePathToDN = ldapTreePathToDN == null ? "" : ldapTreePathToDN;
                    ldapPasswd = ldapPasswd == null ? "" : ldapPasswd;
                    ldapPasswd = ldapPasswd.matches("^\\s*$") ? "" : ldapPasswd;
                    ldapEnv.put("java.naming.factory.initial", ldapDriver);
                    ldapEnv.put("java.naming.provider.url", ldapHostURL);
                    ldapEnv.put("java.naming.security.authentication", ldapAuthType);
                    ldapEnv.put("java.naming.security.principal", ldapTreePathToDN);
                    ldapEnv.put("java.naming.security.credentials", ldapPasswd);
                    this.ctx = new InitialDirContext(ldapEnv);
                }
            }
        }
        return this.ctx;
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricUnreachableException, MetricInvalidException, MetricNotFoundException {
        MetricValue res;
        String objectName = metric.getObjectName();
        String alias = metric.getAttributeName();
        if (metric.isAvail()) {
            try {
                this.hasMonitoringEnabled = this.hasMonitoringEnabled(metric);
                res = new MetricValue(1.0, System.currentTimeMillis());
            }
            catch (NamingException ex) {
                res = new MetricValue(0.0, System.currentTimeMillis());
                this.hasMonitoringEnabled = false;
                this.ctx = null;
                this.log.debug((Object)("[getValue] error:" + ex), (Throwable)ex);
            }
        } else {
            try {
                if (alias.equalsIgnoreCase("connectiontimems")) {
                    res = this.getConnTimeMetric(metric);
                } else if (this.hasMonitoringEnabled) {
                    String[] attrs = alias.split(":");
                    if (attrs[0] == null || attrs[1] == null) {
                        throw new MetricNotFoundException("bad template format");
                    }
                    res = this.getMetric(metric, attrs[0], attrs[1]);
                } else {
                    res = new MetricValue(MetricValue.NONE, System.currentTimeMillis());
                }
            }
            catch (CommunicationException ex) {
                this.log.debug((Object)("[getValue] error:" + ex), (Throwable)ex);
                this.ctx = null;
                throw new MetricNotFoundException(ex.getMessage(), (Throwable)ex);
            }
            catch (NamingException ex) {
                this.log.debug((Object)("[getValue] error:" + ex), (Throwable)ex);
                throw new MetricNotFoundException("Service " + objectName + ", " + alias + " not found", (Throwable)ex);
            }
        }
        return res;
    }

    private MetricValue getConnTimeMetric(Metric metric) throws NamingException {
        long start = System.currentTimeMillis();
        this.hasMonitoringEnabled(metric);
        long now = System.currentTimeMillis();
        return new MetricValue(now - start, now);
    }

    private MetricValue getMetric(Metric metric, String tree, String attr) throws MetricNotFoundException, NamingException {
        NamingEnumeration<SearchResult> enumer = null;
        try {
            String[] a = new String[]{attr};
            SearchControls cons = new SearchControls();
            cons.setSearchScope(0);
            cons.setReturningAttributes(a);
            enumer = this.getDirContext(metric.getProperties()).search(tree, "(&(objectClass=*))", cons);
            while (enumer.hasMore()) {
                SearchResult searchresult = enumer.next();
                Attributes attrs = searchresult.getAttributes();
                Attribute val = attrs.get(attr);
                if (null == val) continue;
                MetricValue metricValue = new MetricValue((Number)new Double(val.get().toString()), System.currentTimeMillis());
                return metricValue;
            }
            throw new MetricNotFoundException("");
        }
        finally {
            if (enumer != null) {
                enumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMonitoringEnabled(Metric metric) throws NamingException {
        NamingEnumeration<SearchResult> enumer = null;
        NamingEnumeration<String> enumerx = null;
        NamingEnumeration enumery = null;
        boolean res = false;
        try {
            String[] a = new String[]{"monitorContext"};
            SearchControls cons = new SearchControls();
            cons.setSearchScope(0);
            cons.setReturningAttributes(a);
            enumer = this.getDirContext(metric.getProperties()).search("", "(&(objectClass=*))", cons);
            while (enumer.hasMore() && !res) {
                SearchResult searchresult = enumer.next();
                Attributes attrs = searchresult.getAttributes();
                enumerx = attrs.getIDs();
                while (enumerx.hasMore()) {
                    String id = enumerx.next();
                    Attribute attr = attrs.get(id);
                    res = true;
                }
            }
        }
        finally {
            if (enumer != null) {
                enumer.close();
            }
            if (enumerx != null) {
                enumerx.close();
            }
            if (enumery != null) {
                enumery.close();
            }
        }
        this.log.debug((Object)("[hasMonitoringEnabled] res=" + res + " metric:" + metric));
        return res;
    }
}

