/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.oracle;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;
import org.hyperic.util.jdbc.DBUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleServerControl
extends ControlPlugin {
    private transient Log log = LogFactory.getLog(OracleServerControl.class);
    private static final String _logCtx = OracleServerControl.class.getName();
    private static final String STARTUP_SCRIPT = "startup.sql";
    private static final String SHUTDOWN_SCRIPT = "shutdown.sql";
    private String startupScript = null;
    private String shutdownScript = null;
    private static final String SCRIPT_PATH = "/pdk/work/scripts/oracle";
    private static final String INSUFFICIENT_PRIVILEGES_ERROR = "ORA-01031: insufficient privileges";

    private String getScriptFullPath(String scriptName, File dirName) throws PluginException {
        File script = new File(dirName, scriptName);
        String scriptStr = null;
        this.log.debug((Object)("[configure] dirName =" + dirName.getAbsolutePath()));
        this.log.debug((Object)("[configure] script =" + script.getAbsolutePath()));
        if (script.exists()) {
            try {
                scriptStr = script.getCanonicalPath();
            }
            catch (IOException ex) {
                scriptStr = script.getAbsolutePath();
            }
        } else {
            throw new PluginException("startup script '" + script + "' NOT FOUND");
        }
        return scriptStr;
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.log.debug((Object)("[configure] config=" + config));
        this.setTimeout(180);
        File dirName = new File(System.getProperty("agent.bundle.home") + SCRIPT_PATH);
        this.log.debug((Object)("[configure] dirName =" + dirName.getAbsolutePath()));
        this.startupScript = this.getScriptFullPath(STARTUP_SCRIPT, dirName);
        this.shutdownScript = this.getScriptFullPath(SHUTDOWN_SCRIPT, dirName);
        if (!this.isOracleConnected(false, config.getValue("jdbcUrl"), false)) {
            throw new PluginException("oracle not connected !!");
        }
    }

    public List getActions() {
        return Arrays.asList("start", "stop", "restart");
    }

    private String findSid(String url) {
        int index = url.lastIndexOf(58);
        int slashIndex = url.lastIndexOf(47);
        if (slashIndex > index) {
            return null;
        }
        String sid = null;
        if (index > -1 && index < url.length() - 1) {
            sid = url.substring(index + 1);
        }
        this.log.debug((Object)("findSid in url=" + url + " found sid=<" + sid + ">"));
        return sid;
    }

    private String getOracleHomeFromEnv(List envVector) throws PluginException {
        if (envVector == null) {
            throw new PluginException("getOracleHomeFromEnv - null env ");
        }
        String oracleHome = null;
        for (Object val : envVector) {
            String str = (String)val;
            if (!str.startsWith("ORACLE_HOME=")) continue;
            oracleHome = str.substring("ORACLE_HOME=".length());
            break;
        }
        this.log.debug((Object)("oracleHome=" + oracleHome));
        if (oracleHome == null) {
            this.log.debug((Object)"didn't find ORACLE_HOME");
        }
        return oracleHome;
    }

    private String getOracleCommandPath(String oracleCmd) throws PluginException {
        String cmd;
        String oracleHome = this.getOracleHomeFromEnv(Execute.getProcEnvironment());
        if (oracleHome != null) {
            File sqlCmdDir = new File(oracleHome, "bin");
            if (!sqlCmdDir.exists()) {
                throw new PluginException("couldn't find bin under:" + oracleHome);
            }
            File sqlCmdFile = new File(sqlCmdDir, oracleCmd);
            if (!sqlCmdFile.exists()) {
                throw new PluginException("couldn't find " + oracleCmd + " under:" + sqlCmdDir);
            }
            this.log.debug((Object)("[getOracleCommandPath] " + oracleCmd + "=" + sqlCmdFile));
            cmd = sqlCmdFile.getAbsolutePath();
        } else {
            this.log.debug((Object)("[getOracleCommandPath] didn't find oracle home - try to run just " + oracleCmd));
            cmd = oracleCmd;
        }
        return cmd;
    }

    private void updateSidInEnv(Execute ex) throws PluginException {
        String url = this.config.getValue("jdbcUrl");
        String sid = this.findSid(url);
        if (sid == null) {
            throw new PluginException("updateSidInEnv failed to find sid: + url=" + url);
        }
        this.log.debug((Object)("updating sid=<" + sid + ">"));
        Object[] env = new String[]{"ORACLE_SID=" + sid};
        this.log.debug((Object)("env before upadte:" + ex.getEnvironment()));
        env = (String[])ArrayUtil.combine((Object[])env, (Object[])ex.getEnvironment());
        ex.setEnvironment((String[])env);
    }

    private List<String> getSqlPlusParameters(String scriptName, String arg, String user) throws PluginException {
        ArrayList<String> cmd = new ArrayList<String>(8);
        this.log.debug((Object)("script=" + scriptName));
        String fileName = "@" + scriptName;
        String sqlCmd = this.getOracleCommandPath("sqlplus");
        String arg1 = "/";
        String arg2 = "as";
        String arg3 = "sysdba";
        String arg4 = fileName;
        if (user != null) {
            cmd.add("su");
            cmd.add("-");
            cmd.add(user);
            cmd.add("-c");
            StringBuilder sb = new StringBuilder(sqlCmd.length() + fileName.length() + 15);
            sb.append(sqlCmd).append(" ").append(arg1).append(" ").append(arg2).append(" ").append(arg3).append(" ").append(arg4);
            if (arg != null) {
                sb.append(" ").append(arg);
            }
            cmd.add(sb.toString());
        } else {
            cmd.add(sqlCmd);
            cmd.add(arg1);
            cmd.add(arg2);
            cmd.add(arg3);
            cmd.add(arg4);
            if (arg != null) {
                cmd.add(arg);
            }
        }
        return cmd;
    }

    private String getErrorString(String outputStr) {
        String[] lines;
        boolean found = false;
        String error = "";
        for (String line : lines = outputStr.split("\r?\n")) {
            if (line.indexOf("ORA-") <= -1) continue;
            error = line;
            found = true;
            break;
        }
        if (!found) {
            error = outputStr;
        }
        return error;
    }

    private void sqlPlusAction(String script, String expectedOutput, String user, String parameter) throws PluginException {
        try {
            this.log.debug((Object)("script=" + script));
            List<String> cmd = this.getSqlPlusParameters(script, parameter, user);
            this.executeCommad(cmd, expectedOutput);
        }
        catch (Exception err) {
            throw new PluginException("sqlplus action failed:" + err.getMessage(), (Throwable)err);
        }
    }

    private void oradminAction(String action, String expectedOutput) throws PluginException {
        this.oradminAction(action, expectedOutput, new ArrayList<String>());
    }

    private void oradminAction(String action, String expectedOutput, List<String> extraArgs) throws PluginException {
        try {
            this.log.debug((Object)("[oradminAction] action=" + action));
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.getOracleCommandPath("oradim"));
            cmd.add("-" + action);
            cmd.add("-SID");
            cmd.add(this.findSid(this.config.getValue("jdbcUrl")));
            cmd.addAll(extraArgs);
            this.executeCommad(cmd, expectedOutput);
        }
        catch (Exception err) {
            throw new PluginException("oradmin action failed:" + err.getMessage(), (Throwable)err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommad(List<String> cmd, String expectedOutput) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        File pwd = new File(System.getProperty("agent.bundle.home"));
        this.log.debug((Object)("[executeCommad] cmd=" + cmd));
        this.log.debug((Object)("[executeCommad] working dir=" + pwd));
        try {
            ExecuteWatchdog watchdog = new ExecuteWatchdog(this.getTimeoutMillis());
            Execute ex = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output), watchdog);
            ex.setWorkingDirectory(pwd);
            ex.setCommandline(cmd.toArray(new String[0]));
            this.updateSidInEnv(ex);
            int exitCode = ex.execute();
            this.log.debug((Object)("[executeCommad] before getting output:" + exitCode));
            String outputStr = output.toString();
            this.log.debug((Object)("[executeCommad] after execute:" + outputStr));
            boolean success = true;
            String err = null;
            if (exitCode != 0) {
                err = this.getErrorString(outputStr);
            } else if (expectedOutput != null && !outputStr.contains(expectedOutput)) {
                err = this.getErrorString(outputStr);
            }
            if (watchdog.killedProcess()) {
                err = "Command did not complete within timeout of " + this.getTimeout() + " seconds";
            }
            if (err != null) {
                this.getLog().debug((Object)("[executeCommad] error: " + err));
                this.setMessage(err);
                success = false;
            }
            if (!success) {
                throw new PluginException(this.getMessage());
            }
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                this.log.error((Object)"failed to close output", (Throwable)e);
            }
        }
    }

    private void startOracle(String user) throws PluginException {
        if (OracleServerControl.isWin32()) {
            this.oradminAction("STARTUP", null);
        } else {
            this.startOracleUnix(user);
        }
        this.startListeners();
    }

    private void startOracleUnix(String user) throws PluginException {
        try {
            this.sqlPlusAction(this.startupScript, "ORACLE instance started.", null, null);
        }
        catch (PluginException ex) {
            String message = this.getMessage();
            if (user != null && message != null && message.indexOf(INSUFFICIENT_PRIVILEGES_ERROR) != -1) {
                this.log.debug((Object)("sqlPlusAction failed with " + message + " trying to run with user=" + user));
                this.sqlPlusAction(this.startupScript, "ORACLE instance started.", user, null);
            }
            throw ex;
        }
    }

    private void stopOracle(String[] args) throws PluginException {
        this.log.debug((Object)("args=" + args));
        String mode = this.getModeParameter(args);
        try {
            if (OracleServerControl.isWin32()) {
                List<String> extraArgs = Arrays.asList("-SHUTMODE", mode);
                this.oradminAction("SHUTDOWN", null, extraArgs);
            } else {
                this.sqlPlusAction(this.shutdownScript, "ORACLE instance shut down.", null, mode);
            }
        }
        catch (PluginException ex) {
            if (OracleServerControl.isWin32()) {
                throw ex;
            }
            String user = this.getUser(args, 1);
            String message = this.getMessage();
            if (user != null && message != null && message.indexOf(INSUFFICIENT_PRIVILEGES_ERROR) != -1) {
                this.log.debug((Object)("sqlPlusAction failed with " + message + " trying to run with user=" + user));
                this.sqlPlusAction(this.shutdownScript, "ORACLE instance shut down.", user, mode);
            }
            throw ex;
        }
    }

    public void doAction(String action, String[] args) throws PluginException {
        this.log.debug((Object)("[doAction] action=" + action));
        this.log.debug((Object)("[doAction] args=" + Arrays.asList(args)));
        this.log.debug((Object)("[doAction] url=" + this.config.getValue("jdbcUrl")));
        this.log.debug((Object)("[doAction] listeners=" + this.config.getValue("listeners")));
        if (action.equals("start")) {
            this.log.debug((Object)"before start");
            this.startOracle(this.getUser(args, 0));
        } else if (action.equals("stop")) {
            this.log.debug((Object)"before stop");
            this.stopOracle(args);
        } else if (action.equals("restart")) {
            this.log.debug((Object)"before restart");
            if (this.isRunning()) {
                this.stopOracle(args);
                this.waitForState("stopped");
            }
            this.startOracle(this.getUser(args, 1));
        } else {
            throw new PluginException("Action '" + action + "' not supported");
        }
        this.setResult(0);
        this.setMessage("OK");
    }

    private String getUser(String[] args, int index) {
        if (args == null || args.length <= index) {
            return null;
        }
        if (args[index].length() > 0) {
            return args[index];
        }
        return null;
    }

    private String getModeParameter(String[] args) {
        this.log.debug((Object)("args=" + (args != null ? Arrays.asList(args) : "null")));
        if (args == null || args.length < 1) {
            return "normal";
        }
        return args[0];
    }

    protected boolean isRunning() {
        Object conn = null;
        try {
            String dbUrl = this.config.getValue("jdbcUrl");
            if (dbUrl == null) {
                throw new PluginException("no url is given");
            }
            boolean isConnected = this.isOracleConnected(false, dbUrl, false);
            this.log.debug((Object)("isRunning returns:" + isConnected));
            return isConnected;
        }
        catch (PluginException e) {
            this.log.debug((Object)("isRunning - got exception: - returning false " + e.getMessage()));
            this.log.debug((Object)"isRunning returns false");
            return false;
        }
    }

    private boolean isOracleConnected(boolean addPerlimAuth, String url, boolean asSysDba) throws PluginException {
        boolean bl;
        block9: {
            OracleConnection conn = null;
            try {
                String user = this.config.getValue("jdbcUser");
                if (user == null) {
                    this.log.debug((Object)"No value for config property jdbcUser");
                    throw new PluginException("No value for config property jdbcUser");
                }
                String password = this.config.getValue("jdbcPassword");
                if (password == null) {
                    this.log.debug((Object)"No value for config property jdbcPassword");
                    throw new PluginException("No value for config property jdbcPassword");
                }
                this.log.debug((Object)("getOracleConnection user=<" + user + "> password=<" + password + ">"));
                OracleDataSource ds = new OracleDataSource();
                Properties prop = new Properties();
                prop.setProperty("user", user);
                prop.setProperty("password", password);
                if (asSysDba) {
                    prop.setProperty("internal_logon", "sysdba");
                }
                if (addPerlimAuth) {
                    prop.setProperty("prelim_auth", "true");
                }
                ds.setConnectionProperties(prop);
                ds.setURL(url);
                this.log.debug((Object)"getOracleConnection before   ");
                conn = (OracleConnection)ds.getConnection();
                this.log.debug((Object)"getOracleConnection success");
                bl = true;
                if (conn == null) break block9;
            }
            catch (SQLException e) {
                try {
                    throw new PluginException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        DBUtil.closeConnection((Object)_logCtx, conn);
                    }
                    throw throwable;
                }
            }
            DBUtil.closeConnection((Object)_logCtx, (Connection)conn);
        }
        return bl;
    }

    private void startListeners() throws PluginException {
        List<String> listeners = Arrays.asList(this.config.getValue("listeners").split(","));
        if (listeners.isEmpty()) {
            listeners.add("");
        }
        for (String listener : listeners) {
            if (!this.listenerIsDown(listener)) continue;
            this.lsnrctlCommand("start", listener);
        }
    }

    private boolean listenerIsDown(String listener) {
        boolean down = false;
        try {
            this.lsnrctlCommand("status", listener);
        }
        catch (PluginException ex) {
            this.log.debug((Object)"[listenerIsDown] error=", (Throwable)ex);
            down = true;
        }
        this.log.debug((Object)("[listenerIsDown] listener '" + listener + "' down=" + down));
        return down;
    }

    private void lsnrctlCommand(String command, String listener) throws PluginException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getOracleCommandPath("lsnrctl"));
        cmd.add(command);
        if (listener.length() > 0) {
            cmd.add(listener);
        }
        this.executeCommad(cmd);
    }

    private String executeCommad(List<String> cmd) throws PluginException {
        String outputStr;
        int exitCode;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        File pwd = new File(System.getProperty("agent.bundle.home"));
        this.log.debug((Object)("[executeCommad] cmd=" + cmd));
        this.log.debug((Object)("[executeCommad] working dir=" + pwd));
        ExecuteWatchdog watchdog = new ExecuteWatchdog(this.getTimeoutMillis());
        try {
            Execute ex = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output), watchdog);
            ex.setWorkingDirectory(pwd);
            ex.setCommandline(cmd.toArray(new String[0]));
            this.updateSidInEnv(ex);
            exitCode = ex.execute();
            this.log.debug((Object)("[executeCommad] exitCode:" + exitCode));
            outputStr = output.toString();
            this.log.debug((Object)("[executeCommad] outputStr:" + outputStr));
        }
        catch (Exception ex) {
            throw new PluginException((Throwable)ex);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                this.log.debug((Object)"failed to close output", (Throwable)e);
            }
        }
        if (exitCode != 0) {
            throw new PluginException(outputStr);
        }
        if (watchdog.killedProcess()) {
            throw new PluginException("Command did not complete within timeout of " + this.getTimeout() + " seconds");
        }
        return outputStr;
    }
}

