/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConfigException;
import org.hyperic.util.security.KeystoreConfig;

public class AgentKeystoreConfig
extends KeystoreConfig {
    private static final String DEFAULT_SSL_KEYSTORE_ALIAS = "hq";
    private static final String SSL_KEYSTORE_ALIAS = "agent.keystore.alias";
    private Log log = LogFactory.getLog(AgentKeystoreConfig.class);
    private boolean acceptUnverifiedCert;

    public AgentKeystoreConfig() {
        AgentConfig cfg;
        String propFile = System.getProperty("agent.propFile", AgentConfig.DEFAULT_PROPFILE);
        try {
            cfg = AgentConfig.newInstance(propFile);
        }
        catch (IOException exc) {
            this.log.error((Object)("Error: " + exc), (Throwable)exc);
            return;
        }
        catch (AgentConfigException exc) {
            this.log.error((Object)("Agent Properties error: " + exc.getMessage()), (Throwable)exc);
            return;
        }
        super.setFilePath(cfg.getBootProperties().getProperty("agent.keystore.path"));
        super.setFilePassword(cfg.getBootProperties().getProperty("agent.keystore.password"));
        super.setAlias(cfg.getBootProperties().getProperty(SSL_KEYSTORE_ALIAS, DEFAULT_SSL_KEYSTORE_ALIAS));
        super.setHqDefault(AgentConfig.PROP_KEYSTORE_PATH[1].equals(this.getFilePath()));
        String prop = cfg.getBootProperties().getProperty("accept.unverified.certificates");
        this.acceptUnverifiedCert = Boolean.parseBoolean(prop);
        String address = "";
        try {
            address = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            this.log.error((Object)e, (Throwable)e);
        }
        super.setKeyCN("Hyperic Agent_" + address);
    }

    public boolean isAcceptUnverifiedCert() {
        return this.acceptUnverifiedCert;
    }
}

