/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bootstrap {
    static ApplicationContext appContext;
    private static Map<String, Object> testBeansByName;
    private static Map<Class<?>, Object> testBeansByType;
    private static String[] springConfigLocations;

    public static <T> T getBean(Class<T> beanClass) {
        Object bean;
        if (testBeansByType.get(beanClass) != null) {
            return (T)testBeansByType.get(beanClass);
        }
        Collection beans = appContext.getBeansOfType(beanClass).values();
        if (beans.isEmpty() && appContext.getParent() != null) {
            beans = appContext.getParent().getBeansOfType(beanClass).values();
        }
        if ((bean = beans.iterator().next()) == null) {
            throw new IllegalArgumentException("Couldn't locate bean of " + beanClass + " type");
        }
        return (T)bean;
    }

    public static Object getBean(String name) {
        if (testBeansByName.get(name) != null) {
            return testBeansByName.get(name);
        }
        Object bean = appContext.getBean(name);
        if (bean == null && appContext.getParent() != null) {
            bean = appContext.getParent().getBean(name);
        }
        return bean;
    }

    public static boolean hasAppContext() {
        return appContext != null;
    }

    public static boolean isServer() {
        return Bootstrap.hasAppContext();
    }

    public static final void setAppContext(ApplicationContext newAppContext) {
        Bootstrap.dispose();
        appContext = newAppContext;
    }

    public static final ApplicationContext getApplicationContext() {
        return appContext;
    }

    public static final void setSpringConfigLocations(String ... arrSpringConfigLocations) {
        springConfigLocations = arrSpringConfigLocations;
    }

    public static final String[] getSpringConfigLocations() {
        return springConfigLocations;
    }

    public static final void dispose() {
        if (appContext != null && appContext instanceof GenericApplicationContext) {
            ((GenericApplicationContext)appContext).close();
        }
        appContext = null;
    }

    public static Resource getResource(String location) {
        return appContext.getResource(location);
    }

    public static void setBean(String name, Object bean) {
        testBeansByName.put(name, bean);
    }

    public static void setBean(Class<?> beanClass, Object bean) {
        testBeansByType.put(beanClass, bean);
    }

    static {
        testBeansByName = new HashMap<String, Object>();
        testBeansByType = new HashMap();
    }
}

