/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.commands;

import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.hq.appdef.shared.InvalidAppdefTypeException;

public class UnscheduleMeasurements_args
extends AgentRemoteValue {
    private static final String PARAM_ENT = "ent";
    private static final String PARAM_NENTS = "nmeas";

    private void setup() {
        this.setNumEntities(0);
    }

    public UnscheduleMeasurements_args() {
        this.setup();
    }

    public UnscheduleMeasurements_args(AgentRemoteValue args) throws AgentRemoteException {
        this.setup();
        int nmeas = args.getValueAsInt(PARAM_NENTS);
        for (int i = 0; i < nmeas; ++i) {
            AppdefEntityID ent;
            String sEnt = args.getValue(PARAM_ENT + i);
            try {
                ent = new AppdefEntityID(sEnt);
            }
            catch (InvalidAppdefTypeException exc) {
                throw new AgentRemoteException("Invalid entity: " + exc.getMessage());
            }
            this.addEntity(ent);
        }
    }

    public void setValue(String key, String val) {
        throw new AgentAssertionException("This should never be called");
    }

    public AppdefEntityID getEntity(int measNo) {
        try {
            String sEnt = this.getValue(PARAM_ENT + measNo);
            return new AppdefEntityID(sEnt);
        }
        catch (InvalidAppdefTypeException exc) {
            throw new AgentAssertionException("Object accessed even though construction failed");
        }
    }

    public void addEntity(AppdefEntityID ent) {
        int numEnts = this.getNumEntities();
        super.setValue(PARAM_ENT + numEnts, ent.getAppdefKey());
        this.setNumEntities(numEnts + 1);
    }

    public int getNumEntities() {
        String val = this.getValue(PARAM_NENTS);
        return Integer.parseInt(val);
    }

    private void setNumEntities(int newMeas) {
        super.setValue(PARAM_NENTS, Integer.toString(newMeas));
    }
}

