/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.stats;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.stats.StatCollector;
import org.hyperic.util.stats.StatUnreachableException;
import org.hyperic.util.stats.StatsObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStatsCollector {
    private final Log log = LogFactory.getLog(AbstractStatsCollector.class);
    private final Map<String, StatCollector> statKeys = new TreeMap<String, StatCollector>();
    private final ConcurrentLinkedQueue<StatsObject> queue = new ConcurrentLinkedQueue();
    private final AtomicBoolean hasStarted = new AtomicBoolean(false);
    private Long pid;
    protected final Sigar sigar = new Sigar();
    protected final MBeanServer mBeanServer;
    public static final String JVM_TOTAL_MEMORY = "JVM_TOTAL_MEMORY";
    public static final String JVM_FREE_MEMORY = "JVM_FREE_MEMORY";
    public static final String JVM_MAX_MEMORY = "JVM_MAX_MEMORY";
    public static final String SIGAR_1MLOAD = "SIGAR_1MLOAD";
    public static final String SIGAR_CPU = "SIGAR_CPU";
    public static final String SIGAR_PROC_RES_MEM = "SIGAR_PROC_RES_MEM";
    public static final String SIGAR_TCP_INERRS = "SIGAR_TCP_INERRS";
    public static final String SIGAR_TCP_RETRANS = "SIGAR_TCP_RETRANS";
    public static final String SIGAR_PAGEOUT = "SIGAR_PAGEOUT";
    public static final String SIGAR_PAGEIN = "SIGAR_PAGEIN";
    public static final String EDEN_MEMORY_USED = "EDEN_MEMORY_USED";
    public static final String SURVIVOR_MEMORY_USED = "SURVIVOR_MEMORY_USED";
    public static final String TENURED_MEMORY_USED = "TENURED_MEMORY_USED";
    public static final String HEAP_MEMORY_USED = "HEAP_MEMORY_USED";
    public static final String JVM_MARKSWEEP_GC = "JVM_MARKSWEEP_GC";
    public static final String JVM_COPY_GC = "JVM_COPY_GC";
    public static final String STATS_COLLECTOR = "STATS_COLLECTOR";

    public AbstractStatsCollector(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
        this.registerInternalStats();
    }

    protected abstract ScheduledFuture<?> scheduleAtFixedRate(Runnable var1, long var2);

    public Map<String, StatCollector> getStatKeys() {
        return this.statKeys;
    }

    void setStarted(boolean started) {
        this.hasStarted.set(started);
    }

    public void register(String statId) {
        if (this.hasStarted.get()) {
            this.log.warn((Object)("Cannot register " + statId + " because the collector has already been started."));
            return;
        }
        if (this.statKeys.containsKey(statId)) {
            return;
        }
        this.statKeys.put(statId, null);
    }

    public void register(StatCollector stat) {
        if (this.hasStarted.get()) {
            this.log.warn((Object)(stat.getId() + " attempted to register in stat collector although it has " + " already been started, not allowing"));
            return;
        }
        if (this.statKeys.containsKey(stat.getId())) {
            this.log.warn((Object)(stat.getId() + " attempted to register in stat collector although it has " + " already been registered, not allowing"));
            return;
        }
        this.statKeys.put(stat.getId(), stat);
    }

    public void addStat(long value, String id) {
        if (!this.statKeys.containsKey(id)) {
            return;
        }
        long now = System.currentTimeMillis();
        StatsObject stat = new StatsObject(value, id);
        this.queue.add(stat);
        long total = System.currentTimeMillis() - now;
        this.queue.add(new StatsObject(total, STATS_COLLECTOR));
    }

    private final void registerInternalStats() {
        this.register(new StatCollector(){

            public String getId() {
                return AbstractStatsCollector.JVM_TOTAL_MEMORY;
            }

            public long getVal() {
                return Runtime.getRuntime().totalMemory();
            }
        });
        this.register(new StatCollector(){

            public String getId() {
                return AbstractStatsCollector.JVM_FREE_MEMORY;
            }

            public long getVal() {
                return Runtime.getRuntime().freeMemory();
            }
        });
        this.register(new StatCollector(){

            public String getId() {
                return AbstractStatsCollector.JVM_MAX_MEMORY;
            }

            public long getVal() {
                return Runtime.getRuntime().maxMemory();
            }
        });
        this.register(new StatCollector(){

            public String getId() {
                return AbstractStatsCollector.SIGAR_1MLOAD;
            }

            public long getVal() throws StatUnreachableException {
                try {
                    return (long)AbstractStatsCollector.this.sigar.getLoadAverage()[0];
                }
                catch (SigarException e) {
                    throw new StatUnreachableException(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.register(new StatCollector(){

            public String getId() {
                return AbstractStatsCollector.SIGAR_CPU;
            }

            public long getVal() throws StatUnreachableException {
                try {
                    return (long)(AbstractStatsCollector.this.sigar.getProcCpu(AbstractStatsCollector.this.getProcPid()).getPercent() * 100.0);
                }
                catch (SigarException e) {
                    throw new StatUnreachableException(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.register(new StatCollector(){

            public String getId() {
                return AbstractStatsCollector.SIGAR_PROC_RES_MEM;
            }

            public long getVal() throws StatUnreachableException {
                try {
                    return AbstractStatsCollector.this.sigar.getProcMem(AbstractStatsCollector.this.getProcPid()).getResident();
                }
                catch (SigarException e) {
                    throw new StatUnreachableException(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.register(new StatCollector(){
            private long last = 0L;

            public String getId() {
                return AbstractStatsCollector.SIGAR_TCP_INERRS;
            }

            public long getVal() throws StatUnreachableException {
                try {
                    long curr = AbstractStatsCollector.this.sigar.getTcp().getInErrs();
                    long rtn = curr - this.last;
                    this.last = curr;
                    return rtn;
                }
                catch (SigarException e) {
                    throw new StatUnreachableException(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.register(new StatCollector(){
            private long last = 0L;
            private boolean isFirst = true;

            public String getId() {
                return AbstractStatsCollector.SIGAR_TCP_RETRANS;
            }

            public long getVal() throws StatUnreachableException {
                try {
                    long curr = AbstractStatsCollector.this.sigar.getTcp().getRetransSegs();
                    long rtn = curr - this.last;
                    this.last = curr;
                    if (this.isFirst) {
                        this.isFirst = false;
                        throw new StatUnreachableException("don't return first value");
                    }
                    return rtn;
                }
                catch (SigarException e) {
                    throw new StatUnreachableException(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.register(new StatCollector(){
            private long last = 0L;
            private boolean isFirst = true;

            public String getId() {
                return AbstractStatsCollector.SIGAR_PAGEOUT;
            }

            public long getVal() throws StatUnreachableException {
                try {
                    long curr = AbstractStatsCollector.this.sigar.getSwap().getPageOut();
                    long rtn = curr - this.last;
                    this.last = curr;
                    if (this.isFirst) {
                        this.isFirst = false;
                        throw new StatUnreachableException("don't return first value");
                    }
                    return rtn;
                }
                catch (SigarException e) {
                    throw new StatUnreachableException(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.register(new StatCollector(){
            private long last = 0L;
            private boolean isFirst = true;

            public String getId() {
                return AbstractStatsCollector.SIGAR_PAGEIN;
            }

            public long getVal() throws StatUnreachableException {
                try {
                    long curr = AbstractStatsCollector.this.sigar.getSwap().getPageIn();
                    long rtn = curr - this.last;
                    this.last = curr;
                    if (this.isFirst) {
                        this.isFirst = false;
                        throw new StatUnreachableException("don't return first value");
                    }
                    return rtn;
                }
                catch (SigarException e) {
                    throw new StatUnreachableException(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.register(new MBeanCollector(EDEN_MEMORY_USED, "java.lang:type=MemoryPool,name=", new String[]{"Par Eden Space", "PS Eden Space", "Eden Space"}, "Usage", "used"));
        this.register(new MBeanCollector(SURVIVOR_MEMORY_USED, "java.lang:type=MemoryPool,name=", new String[]{"Par Survivor Space", "PS Survivor Space", "Survivor Space"}, "Usage", "used"));
        this.register(new MBeanCollector(TENURED_MEMORY_USED, "java.lang:type=MemoryPool,name=", new String[]{"CMS Old Gen", "PS Old Gen", "Tenured Gen"}, "Usage", "used"));
        this.register(new MBeanCollector(HEAP_MEMORY_USED, "java.lang:type=Memory", new String[]{""}, "HeapMemoryUsage", "used"));
        this.register(new MBeanCollector(JVM_MARKSWEEP_GC, "java.lang:type=GarbageCollector,name=", new String[]{"ConcurrentMarkSweep", "PS MarkSweep"}, "CollectionTime", true));
        this.register(new MBeanCollector(JVM_COPY_GC, "java.lang:type=GarbageCollector,name=", new String[]{"Copy", "ParNew", "PS Scavenge"}, "CollectionTime", true));
        this.register(STATS_COLLECTOR);
    }

    protected long getProcPid() {
        if (this.pid != null) {
            return this.pid;
        }
        this.pid = new Long(this.sigar.getPid());
        return this.pid;
    }

    public StatsObject generateMarker() {
        StatsObject marker = new StatsObject(-1L, null);
        this.queue.add(marker);
        return marker;
    }

    public StatsObject pollQueue() {
        return this.queue.poll();
    }

    public void destory() {
        this.queue.clear();
        this.statKeys.clear();
    }

    protected class MBeanCollector
    implements StatCollector {
        private final String _id;
        private final String _objectName;
        private final String _attrName;
        private final String _valProp;
        private final String[] _names;
        private StatUnreachableException _ex = null;
        private int failures = 0;
        private final boolean _isComposite;
        private final boolean _isTrend;
        private long _last = 0L;

        protected MBeanCollector(String id, String objectName, String[] names, String attrName, boolean trend) {
            this._id = id;
            this._objectName = objectName;
            this._attrName = attrName;
            this._names = names;
            this._valProp = null;
            this._isComposite = false;
            this._isTrend = trend;
        }

        protected MBeanCollector(String id, String objectName, String attrName, boolean trend) {
            this._id = id;
            this._objectName = objectName;
            this._attrName = attrName;
            this._names = new String[]{""};
            this._valProp = null;
            this._isComposite = false;
            this._isTrend = trend;
        }

        protected MBeanCollector(String id, String objectName, String[] names, String attrName, String valProp) {
            this._names = names;
            this._id = id;
            this._objectName = objectName;
            this._attrName = attrName;
            this._valProp = valProp;
            this._isComposite = true;
            this._isTrend = false;
        }

        public String getId() {
            return this._id;
        }

        public long getVal() throws StatUnreachableException {
            if (this._ex != null && this.failures >= 10) {
                throw this._ex;
            }
            Exception exception = null;
            for (int i = 0; i < this._names.length; ++i) {
                try {
                    if (this._isComposite) {
                        long val = this.getComposite(this._names[i]);
                        long rtn = this._isTrend ? val - this._last : val;
                        this._last = val;
                        return rtn;
                    }
                    long val = this.getValue(this._names[i]);
                    long rtn = this._isTrend ? val - this._last : val;
                    this._last = val;
                    return rtn;
                }
                catch (Exception e) {
                    exception = e;
                    continue;
                }
            }
            ++this.failures;
            String msg = this._objectName + " query failed";
            if (exception == null) {
                this._ex = new StatUnreachableException(msg);
                throw this._ex;
            }
            this._ex = new StatUnreachableException(msg, (Throwable)exception);
            throw this._ex;
        }

        private final long getComposite(String name) throws StatUnreachableException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, MalformedObjectNameException, NullPointerException {
            ObjectName objName = new ObjectName(this._objectName + name);
            CompositeDataSupport cds = (CompositeDataSupport)AbstractStatsCollector.this.mBeanServer.getAttribute(objName, this._attrName);
            long val = ((Number)cds.get(this._valProp)).longValue();
            this.failures = 0;
            return val;
        }

        private final long getValue(String name) throws MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
            ObjectName _objName = new ObjectName(this._objectName + name);
            long rtn = ((Number)AbstractStatsCollector.this.mBeanServer.getAttribute(_objName, this._attrName)).longValue();
            this.failures = 0;
            return rtn;
        }
    }

    protected class StatSampler
    implements StatCollector {
        private final StatCollector stat;
        private final String id;
        private final AtomicLong value = new AtomicLong();
        private final AtomicReference<StatUnreachableException> exceptionRef = new AtomicReference();

        protected StatSampler(StatCollector s) {
            this.id = s.getId() + "_MAX";
            this.stat = s;
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!AbstractStatsCollector.this.hasStarted.get()) {
                        return;
                    }
                    try {
                        long newVal = StatSampler.this.stat.getVal();
                        AtomicLong atomicLong = StatSampler.this.value;
                        synchronized (atomicLong) {
                            long val = StatSampler.this.value.get();
                            if (Math.abs(newVal) > Math.abs(val)) {
                                StatSampler.this.value.set(newVal);
                            }
                            StatSampler.this.exceptionRef.set(null);
                        }
                    }
                    catch (StatUnreachableException e) {
                        StatSampler.this.exceptionRef.set(e);
                    }
                    catch (Throwable t) {
                        AbstractStatsCollector.this.log.error((Object)t, t);
                    }
                }
            };
            AbstractStatsCollector.this.scheduleAtFixedRate(runnable, 1000L);
        }

        public String getId() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getVal() throws StatUnreachableException {
            StatUnreachableException ex = this.exceptionRef.get();
            if (ex != null) {
                throw ex;
            }
            AtomicLong atomicLong = this.value;
            synchronized (atomicLong) {
                return this.value.getAndSet(0L);
            }
        }
    }
}

