/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.hyperic.tools.db.Column;
import org.hyperic.tools.db.Table;
import org.hyperic.util.jdbc.PointbaseSequence;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class PointbaseColumn
extends Column {
    private static int s_iSequenceCount = -1;
    private boolean m_bSequenceInit = false;
    private Table m_table;

    protected PointbaseColumn(Node node, Table table) throws SAXException {
        super(node, table);
        this.m_table = table;
    }

    protected String getSizeCommand(List cmds) {
        if (this.getType().equals("INTEGER")) {
            return "";
        }
        return super.getSizeCommand(cmds);
    }

    protected String getDefaultCommand(List cmds) {
        String strCmd = new String();
        switch (this.getDefault()) {
            case 1: {
                strCmd = strCmd + "IDENTITY";
                if (this.getInitialSequence() > 0) {
                    strCmd = strCmd + '(' + this.getInitialSequence();
                }
                if (this.getIncrementSequence() > 0) {
                    strCmd = strCmd + ',' + this.getIncrementSequence();
                }
                strCmd = strCmd + ")";
                break;
            }
            case 3: {
                try {
                    PointbaseSequence.initSequences((Connection)this.m_table.getDBSetup().getConn());
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                cmds.add(PointbaseSequence.getCreateCommand((String)(this.m_strTableName + '_' + this.getName() + "_SEQ"), (int)this.getInitialSequence(), (int)this.getIncrementSequence()));
                break;
            }
            case 2: {
                strCmd = strCmd + "CURRENT_TIME";
            }
        }
        return strCmd;
    }

    protected void getDropCommands(List cmds) {
        if (this.hasDefault()) {
            switch (this.getDefault()) {
                case 3: {
                    cmds.add(PointbaseSequence.getDropCommand((String)(this.m_strTableName + '_' + this.getName() + "_SEQ")));
                }
            }
        }
    }

    protected static int getClassType() {
        return 7;
    }
}

