/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.util.Iterator;
import java.util.List;
import org.hyperic.tools.db.Data;
import org.hyperic.tools.db.DataSet;
import org.hyperic.tools.db.Table;
import org.hyperic.util.StrongCollection;
import org.hyperic.util.StrongList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XmlDataSet
extends DataSet {
    private Iterator m_iterator;
    private List m_listCurRow;

    protected XmlDataSet(Table table, Node nodeTable) {
        super(table.getName(), table.getDBSetup());
        StrongCollection collRows = new StrongCollection("java.util.List");
        NodeList listData = nodeTable.getChildNodes();
        for (int i = 0; i < listData.getLength(); ++i) {
            Node node = listData.item(i);
            if (!XmlDataSet.isDataSet(node)) continue;
            StrongList listRow = new StrongList("org.hyperic.tools.db.Data");
            NamedNodeMap map = node.getAttributes();
            for (int iAttr = 0; iAttr < map.getLength(); ++iAttr) {
                listRow.add(new Data(map.item(iAttr)));
            }
            collRows.add(listRow);
        }
        this.m_iterator = collRows.iterator();
    }

    protected int getNumberColumns() {
        return this.m_listCurRow.size();
    }

    protected Data getData(int columnIndex) {
        return (Data)this.m_listCurRow.get(columnIndex);
    }

    protected boolean next() {
        boolean bResult = this.m_iterator.hasNext();
        this.m_listCurRow = bResult ? (List)this.m_iterator.next() : null;
        return bResult;
    }

    protected static boolean isDataSet(Node node) {
        String strTmp = node.getNodeName();
        return strTmp.equalsIgnoreCase("data");
    }
}

