/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db.plan;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import org.hyperic.tools.db.plan.Plan;
import org.hyperic.util.jdbc.JDBC;

public class DBPlan {
    private static final String EMPTY = "";
    private static final String VERSION = "DBPlan, Version 1.0.0";
    private static final String COPYRIGHT = "Copyright (C) Covalent Technologies, Inc., All Rights Reserved.";
    private static final String SYNTAX = "DBPlan <JDBC> <User> <Password> <Command>";
    private String m_jdbc;
    private Connection m_conn;
    private String m_user;
    private String m_password;
    private String m_cmd;

    public static void main(String[] args) {
        System.out.println("DBPlan, Version 1.0.0\nCopyright (C) Covalent Technologies, Inc., All Rights Reserved.\n");
        if (args.length < 4) {
            System.out.println(SYNTAX);
            System.exit(-1);
        }
        String jdbc = args[0];
        String user = args[1];
        String password = args[2];
        String cmd = args[3];
        DBPlan dbplan = new DBPlan(jdbc, user, password, cmd);
        try {
            dbplan.plan();
        }
        catch (SQLException e) {
            JDBC.printSQLException((SQLException)e);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public DBPlan(String jdbc, String user, String password, String cmd) {
        this.m_jdbc = jdbc;
        this.m_user = user;
        this.m_password = password;
        this.m_cmd = cmd;
    }

    public void plan() throws SQLException {
        this.openConnections();
        this.printPlan();
        this.closeConnections();
    }

    protected void printPlan() throws SQLException {
        try {
            Plan.createPlan(this.m_jdbc).printPlan(this.m_conn, this.m_cmd);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e.toString());
        }
    }

    protected void openConnections() throws SQLException {
        try {
            JDBC.loadDriver((String)this.m_jdbc);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e.toString());
        }
        this.m_conn = DriverManager.getConnection(this.m_jdbc, this.m_user, this.m_password);
        this.m_conn.setAutoCommit(false);
    }

    protected void closeConnections() {
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static void printResults(ResultSet result) throws SQLException {
        ResultSetMetaData meta = result.getMetaData();
        int[] len = new int[meta.getColumnCount()];
        Vector[] cols = new Vector[meta.getColumnCount()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = new Vector();
        }
        for (int col = 0; col < meta.getColumnCount(); ++col) {
            String label = meta.getColumnLabel(col + 1);
            if (label == null) {
                label = EMPTY;
            }
            len[col] = Math.max(len[col], label.length());
            cols[col].add(label);
        }
        int row = 1;
        while (result.next()) {
            for (int col = 0; col < meta.getColumnCount(); ++col) {
                String data = result.getString(col + 1);
                if (data == null) {
                    data = EMPTY;
                }
                len[col] = Math.max(len[col], data.length());
                cols[col].add(data);
            }
            ++row;
        }
        for (row = 0; row < cols[0].size(); ++row) {
            for (int col = 0; col < cols.length; ++col) {
                String padded = DBPlan.pad((String)cols[col].get(row), len[col] + 1, ' ');
                System.out.print(padded);
            }
            System.out.println();
        }
    }

    private static String pad(String value, int length, char ch) {
        StringBuffer padder = new StringBuffer(value);
        if (value.length() < length) {
            for (int i = 0; i < length - value.length(); ++i) {
                padder.append(ch);
            }
        }
        return padder.toString();
    }
}

