/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.detector;

import com.vmware.vfabric.hyperic.plugin.vfgf.GFProductPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.jmx.MxServerDetector;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GF7ServerDetector
extends MxServerDetector {
    private static final Log log = LogFactory.getLog(GF7ServerDetector.class);
    private static String PROP_LOCATORS = "locators";
    private static String PROP_MEMBER = "member";
    private static String PROP_PORT = "port";
    private static String PROP_JMXURL = "jmx.url";
    private static String ERR_LOCATORS_NOT_DEFINED = "No Locators defined. Please configure in the platform's Configuration Properties";

    public List<ServerResource> getServerResources(ConfigResponse platformConfig) throws PluginException {
        MBeanServerConnection mServer;
        log.debug((Object)("[getServerRsources] platformConfig = " + platformConfig));
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        String locators = platformConfig.getValue(PROP_LOCATORS);
        if (locators == null || locators.isEmpty()) {
            log.debug((Object)("[getServerResources] " + ERR_LOCATORS_NOT_DEFINED));
            return servers;
        }
        String url = GFProductPlugin.getJmxUrl(locators);
        if (url.isEmpty()) {
            return servers;
        }
        platformConfig.setValue("jmx.url", url);
        log.debug((Object)("[getServerResources] platformConfig=" + platformConfig));
        log.debug((Object)("[getServerResources] url=" + url));
        JMXConnector connector = null;
        try {
            connector = MxUtil.getMBeanConnector((Properties)platformConfig.toProperties());
            mServer = connector.getMBeanServerConnection();
        }
        catch (IOException e) {
            GFProductPlugin.resetJmxUrl();
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            MxUtil.close((JMXConnector)connector);
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        String objName = this.getTypeProperty("OBJECT_NAME");
        log.debug((Object)("[getServerResources] objName=" + objName));
        Set<Object> names = new HashSet();
        try {
            names = mServer.queryNames(new ObjectName(objName), null);
        }
        catch (MalformedObjectNameException e) {
            log.debug((Object)("[getServerResources] " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            log.debug((Object)("[getServerResources] " + e.getMessage()), (Throwable)e);
        }
        this.getLog().debug((Object)("[getServerResources] discovered " + names.size() + " servers"));
        for (ObjectName objectName : names) {
            ServerResource server = this.createServerResource(objectName.toString());
            ConfigResponse config = new ConfigResponse();
            ConfigResponse cprops = new ConfigResponse();
            ConfigResponse controlConfig = new ConfigResponse();
            config.setValue(PROP_MEMBER, objectName.getKeyProperty(PROP_MEMBER));
            String port = objectName.getKeyProperty(PROP_PORT);
            log.debug((Object)("[getServerResources] port=" + port));
            if (port != null) {
                config.setValue(PROP_PORT, port);
            }
            config.setValue(PROP_LOCATORS, locators);
            server.setName(GF7ServerDetector.getPlatformName() + " " + this.getTypeInfo().getName() + " " + objectName.getKeyProperty(PROP_MEMBER));
            server.setControlConfig(controlConfig);
            this.setProductConfig(server, config);
            this.setMeasurementConfig(server, new ConfigResponse());
            server.setCustomProperties(cprops);
            servers.add(server);
        }
        return servers;
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        String locators = serverConfig.getValue(PROP_LOCATORS);
        if (locators == null || locators.isEmpty()) {
            throw new PluginException(ERR_LOCATORS_NOT_DEFINED);
        }
        String url = GFProductPlugin.getJmxUrl(locators);
        if (url.isEmpty()) {
            throw new PluginException("Unable to determine jmx url from locators");
        }
        serverConfig.setValue(PROP_JMXURL, url);
        return super.discoverServices(serverConfig);
    }
}

