/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.mx;

import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberInfo;
import com.vmware.vfabric.hyperic.plugin.vfgf.util.GFMXUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGFJmxConnection {
    private static final Log log = LogFactory.getLog(AbstractGFJmxConnection.class);
    protected Properties props;
    private ObjectName adminDistributedSystemMBean;

    public AbstractGFJmxConnection(Properties props) {
        this.props = props;
    }

    public AbstractGFJmxConnection(ConfigResponse config) {
        this.props = config.toProperties();
    }

    public AbstractGFJmxConnection(String url, String user, String password) {
        Properties p = this.getProperties();
        if (url != null) {
            p.put("jmx.url", url);
        }
        if (user != null) {
            p.put("jmx.username", user);
        }
        if (password != null) {
            p.put("jmx.password", password);
        }
    }

    public AbstractGFJmxConnection(String url) {
        this(url, null, null);
    }

    private AbstractGFJmxConnection() {
    }

    protected Properties getProperties() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    protected ObjectName connectToSystem() {
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName gemFireAgentMBean = new ObjectName("GemFire:type=Agent");
            this.adminDistributedSystemMBean = (ObjectName)mServer.invoke(gemFireAgentMBean, "connectToSystem", GFMXUtils.EMPTY_ARGS, GFMXUtils.EMPTY_DEF);
            log.debug((Object)("[connectToSystem] Found distributed system: " + this.adminDistributedSystemMBean));
            return this.adminDistributedSystemMBean;
        }
        catch (Exception e) {
            log.debug((Object)("[connectToSystem] Error to connect jmx agent to system: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected ObjectName[] manageCacheServers() {
        this.connectToSystem();
        String dsName = GFMXUtils.getId(this.adminDistributedSystemMBean);
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName bean = new ObjectName("GemFire:type=AdminDistributedSystem");
            ObjectName[] systemMemberMBean = (ObjectName[])mServer.invoke(GFMXUtils.combine(bean, "id", dsName), "manageCacheServers", GFMXUtils.EMPTY_ARGS, GFMXUtils.EMPTY_DEF);
            return systemMemberMBean;
        }
        catch (Exception e) {
            log.debug((Object)("[manageCacheServers] Error requesting cache servers: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected ObjectName[] manageSystemMembersApplications() {
        this.connectToSystem();
        String dsName = GFMXUtils.getId(this.adminDistributedSystemMBean);
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName bean = new ObjectName("GemFire:type=AdminDistributedSystem");
            ObjectName[] systemMemberMBean = (ObjectName[])mServer.invoke(GFMXUtils.combine(bean, "id", dsName), "manageSystemMemberApplications", GFMXUtils.EMPTY_ARGS, GFMXUtils.EMPTY_DEF);
            return systemMemberMBean;
        }
        catch (Exception e) {
            log.debug((Object)("Error requesting system member applications: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected ObjectName[] manageCacheVMStats(String id) {
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName bean = new ObjectName("GemFire.CacheVm:type=CacheVm");
            ObjectName[] statMBean = (ObjectName[])mServer.invoke(GFMXUtils.combine(bean, "id", id), "manageStats", GFMXUtils.EMPTY_ARGS, GFMXUtils.EMPTY_DEF);
            return statMBean;
        }
        catch (Exception e) {
            log.debug((Object)("[manageCacheVMStats] Error requesting statistics mbeans: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected ObjectName[] manageApplicationStats(String id) {
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName bean = new ObjectName("GemFire.Member:type=Application");
            ObjectName[] statMBean = (ObjectName[])mServer.invoke(GFMXUtils.combine(bean, "id", id), "manageStats", GFMXUtils.EMPTY_ARGS, GFMXUtils.EMPTY_DEF);
            return statMBean;
        }
        catch (Exception e) {
            log.debug((Object)("[manageApplicationStats] Error requesting statistics mbeans: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected ObjectName[] manageCaches() {
        ArrayList<ObjectName> caches = new ArrayList<ObjectName>();
        ObjectName[] cacheServers = this.manageCacheServers();
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            for (ObjectName objectName : cacheServers) {
                ObjectName cacheMBean = (ObjectName)mServer.invoke(objectName, "manageCache", GFMXUtils.EMPTY_ARGS, GFMXUtils.EMPTY_DEF);
                caches.add(cacheMBean);
            }
            return caches.toArray(new ObjectName[0]);
        }
        catch (Exception e) {
            log.debug((Object)("[manageCaches] " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected ObjectName[] manageCaches(ObjectName[] cacheVms) {
        ArrayList<ObjectName> caches = new ArrayList<ObjectName>();
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            for (ObjectName objectName : cacheVms) {
                ObjectName cacheMBean = (ObjectName)mServer.invoke(objectName, "manageCache", GFMXUtils.EMPTY_ARGS, GFMXUtils.EMPTY_DEF);
                caches.add(cacheMBean);
            }
            return caches.toArray(new ObjectName[0]);
        }
        catch (Exception e) {
            log.debug((Object)("[manageCaches] " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public ObjectName manageCache(ObjectName cacheVm) {
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName cacheMBean = (ObjectName)mServer.invoke(cacheVm, "manageCache", GFMXUtils.EMPTY_ARGS, GFMXUtils.EMPTY_DEF);
            return cacheMBean;
        }
        catch (Exception e) {
            log.debug((Object)("[manageCache] " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public ObjectName[] manageRegions(ObjectName cache) {
        ArrayList<ObjectName> regions = new ArrayList<ObjectName>();
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            Set rootRegions = (Set)mServer.getAttribute(cache, "rootRegionNames");
            for (String s : rootRegions) {
                log.debug((Object)("[manageRegions] Found root region: " + s));
                ObjectName region = (ObjectName)mServer.invoke(cache, "manageRegion", new Object[]{s}, new String[]{"java.lang.String"});
                regions.add(region);
                this.manageSubRegions(region, cache, regions);
            }
            return regions.toArray(new ObjectName[0]);
        }
        catch (Exception e) {
            log.debug((Object)("[manageRegions] " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public void manageSubRegions(ObjectName region, ObjectName cache, ArrayList<ObjectName> regions) {
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            Set subRegions = (Set)mServer.getAttribute(region, "subregionFullPaths");
            for (String s : subRegions) {
                log.debug((Object)("[manageSubRegions] Found sub region: " + s));
                ObjectName subRegion = (ObjectName)mServer.invoke(cache, "manageRegion", new Object[]{s}, new String[]{"java.lang.String"});
                regions.add(subRegion);
                this.manageSubRegions(subRegion, cache, regions);
            }
        }
        catch (Exception e) {
            log.debug((Object)("[manageSubRegions] " + e.getMessage()), (Throwable)e);
        }
    }

    protected Map<String, Double> getStats(MemberInfo member, String name) {
        if (member.isStatisticsDirty()) {
            ObjectName[] statObjects = null;
            if (member.getMemberType() == 1) {
                statObjects = this.manageCacheVMStats(member.getGfid());
            } else if (member.getMemberType() == 2) {
                statObjects = this.manageApplicationStats(member.getGfid());
            }
            if (statObjects != null) {
                member.setStatisticsDirty(false);
            } else {
                return null;
            }
        }
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName bean = new ObjectName("GemFire.Statistic:source=" + member.getGfid() + ",name=" + name + ",*");
            Set<ObjectInstance> res = mServer.queryMBeans(bean, null);
            if (res.size() == 0) {
                return null;
            }
            ObjectInstance ins = (ObjectInstance)res.toArray()[0];
            MBeanInfo info = mServer.getMBeanInfo(ins.getObjectName());
            this.refreshStatistics(ins.getObjectName());
            MBeanAttributeInfo[] atts = info.getAttributes();
            ArrayList<String> l = new ArrayList<String>();
            for (int i = 0; i < atts.length; ++i) {
                MBeanAttributeInfo mBeanAttributeInfo = atts[i];
                l.add(mBeanAttributeInfo.getName());
            }
            String[] nameArray = l.toArray(new String[0]);
            AttributeList attlist = mServer.getAttributes(ins.getObjectName(), nameArray);
            Hashtable<String, Double> map = new Hashtable<String, Double>();
            for (int i = 0; i < attlist.size(); ++i) {
                Attribute o = (Attribute)attlist.get(i);
                if (!(o.getValue() instanceof Number)) continue;
                map.put(o.getName(), ((Number)o.getValue()).doubleValue());
            }
            return map;
        }
        catch (Exception e) {
            log.debug((Object)("[getStats] " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected Map<String, Double> getStats(MemberInfo member, String name, String[] keys) {
        Hashtable<String, Double> map = new Hashtable<String, Double>();
        if (member.isStatisticsDirty()) {
            ObjectName[] statObjects = null;
            if (member.getMemberType() == 1) {
                statObjects = this.manageCacheVMStats(member.getGfid());
            } else if (member.getMemberType() == 2) {
                statObjects = this.manageApplicationStats(member.getGfid());
            }
            if (statObjects != null) {
                member.setStatisticsDirty(false);
            } else {
                log.debug((Object)"Can't manage stats MBean, returning empty map.");
                return map;
            }
        }
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName bean = new ObjectName("GemFire.Statistic:source=" + member.getGfid() + ",name=" + name + ",*");
            Set<ObjectInstance> res = mServer.queryMBeans(bean, null);
            if (res.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't query stats MBean, returning empty map. Bean is: " + bean != null ? bean.getCanonicalName() : "null"));
                }
                return map;
            }
            ObjectInstance ins = (ObjectInstance)res.toArray()[0];
            this.refreshStatistics(ins.getObjectName());
            AttributeList attlist = mServer.getAttributes(ins.getObjectName(), keys);
            for (int i = 0; i < attlist.size(); ++i) {
                Attribute o = (Attribute)attlist.get(i);
                if (!(o.getValue() instanceof Number)) continue;
                map.put(o.getName(), ((Number)o.getValue()).doubleValue());
            }
            return map;
        }
        catch (Exception e) {
            log.info((Object)("[getStats] Unable to collect stats." + e.getMessage()));
            log.debug((Object)("[getStats] " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected boolean refreshStatistics(ObjectName statMBean) {
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            mServer.invoke(statMBean, "refresh", GFMXUtils.EMPTY_ARGS, GFMXUtils.EMPTY_DEF);
            return true;
        }
        catch (Exception e) {
            log.debug((Object)("[refreshStatistics] Error updating stats for mbean:" + statMBean), (Throwable)e);
            return false;
        }
    }

    protected ObjectName getCacheServerObject(String gfid) {
        ObjectName bean = null;
        try {
            bean = new ObjectName("GemFire.CacheVm:type=CacheVm,id=" + gfid);
        }
        catch (MalformedObjectNameException e) {
            log.debug((Object)("[getCacheServerObject] " + e.getMessage()), (Throwable)e);
        }
        return bean;
    }

    protected ObjectName getApplicationObject(String gfid) {
        ObjectName bean = null;
        try {
            bean = new ObjectName("GemFire.Member:type=Application,id=" + gfid);
        }
        catch (MalformedObjectNameException e) {
            log.debug((Object)("[getApplicationObject] " + e.getMessage()), (Throwable)e);
        }
        return bean;
    }

    protected String getAgentVersionString() {
        String version = "";
        try {
            MBeanServerConnection mServer = MxUtil.getMBeanServer((Properties)this.props);
            ObjectName gemFireAgentMBean = new ObjectName("GemFire:type=Agent");
            version = (String)mServer.getAttribute(gemFireAgentMBean, "version");
        }
        catch (MalformedURLException mue) {
            log.debug((Object)"[getAgentVersionString] Can't use given jmx url", (Throwable)mue);
        }
        catch (Exception e) {
            log.debug((Object)"[getAgentVersionString] General error talking to jmx agent", (Throwable)e);
        }
        return version;
    }
}

