/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server.monitor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentMonitorValue;
import org.hyperic.hq.agent.server.monitor.AgentMonitorException;
import org.hyperic.hq.agent.server.monitor.AgentMonitorIncalculableException;
import org.hyperic.hq.agent.server.monitor.AgentMonitorInterface;
import org.hyperic.hq.agent.server.monitor.AgentMonitorInternalException;

public abstract class AgentMonitorSimple
implements AgentMonitorInterface {
    private HashMap methodMap;
    private String[] methodKeys;
    private int[] methodTypes;
    private Log log = LogFactory.getLog(this.getClass());

    public AgentMonitorSimple() {
        this.methodMap = new HashMap();
        this.setupMethodMap();
    }

    private void setupMethodMap() {
        Class<?> retType;
        Class<String[]> asClass = String[].class;
        Class<int[]> aiClass = int[].class;
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] exceptions;
            Method m = methods[i];
            if (!m.getName().startsWith("get") || m.getParameterTypes().length != 0 || (exceptions = m.getExceptionTypes()).length != 1 || !exceptions[0].equals(AgentMonitorException.class) || !(retType = m.getReturnType()).equals(String.class) && !retType.equals(Double.TYPE) && !retType.equals(asClass) && !retType.equals(aiClass)) continue;
            this.methodMap.put(m.getName().substring(3), m);
        }
        this.methodKeys = new String[this.methodMap.size()];
        this.methodTypes = new int[this.methodKeys.length];
        int j = 0;
        for (String key : this.methodMap.keySet()) {
            int type;
            Method m = (Method)this.methodMap.get(key);
            retType = m.getReturnType();
            this.methodKeys[j] = key;
            if (retType.equals(String.class)) {
                type = 0;
            } else if (retType.equals(Double.TYPE)) {
                type = 1;
            } else if (retType.equals(asClass)) {
                type = 2;
            } else if (retType.equals(aiClass)) {
                type = 3;
            } else {
                throw new IllegalStateException("Should never get here");
            }
            this.methodTypes[j] = type;
            ++j;
        }
    }

    public AgentMonitorValue[] getMonitorValues(String[] monitorKeys) {
        Object[] noArgs = new Object[]{};
        AgentMonitorValue[] res = new AgentMonitorValue[monitorKeys.length];
        for (int i = 0; i < monitorKeys.length; ++i) {
            AgentMonitorValue val;
            block13: {
                String key = monitorKeys[i];
                Method m = (Method)this.methodMap.get(key);
                val = new AgentMonitorValue();
                if (m == null) {
                    val.setErrCode(2);
                } else {
                    try {
                        Object invokeRes = m.invoke((Object)this, noArgs);
                        Class<?> resClass = invokeRes.getClass();
                        if (resClass.equals(String.class)) {
                            val.setValue((String)invokeRes);
                            break block13;
                        }
                        if (resClass.equals(Double.TYPE) || resClass.equals(Double.class)) {
                            val.setValue((Double)invokeRes);
                            break block13;
                        }
                        if (resClass.equals(String[].class)) {
                            val.setValue((String[])invokeRes);
                            break block13;
                        }
                        if (resClass.equals(int[].class)) {
                            val.setValue((int[])invokeRes);
                            break block13;
                        }
                        throw new IllegalStateException("Unhandled res type: " + resClass);
                    }
                    catch (IllegalAccessException exc) {
                        this.log.error((Object)("Unable to access monitor method '" + key + "': " + exc.getMessage()), (Throwable)exc);
                        val.setErrCode(4);
                    }
                    catch (IllegalArgumentException exc) {
                        this.log.error((Object)("Invalid arguments passed to monitor method '" + key + "': " + exc.getMessage()), (Throwable)exc);
                        val.setErrCode(4);
                    }
                    catch (InvocationTargetException exc) {
                        Throwable tExc = exc.getTargetException();
                        if (tExc instanceof AgentMonitorIncalculableException) {
                            val.setErrCode(1);
                        }
                        if (tExc instanceof AgentMonitorInternalException) {
                            val.setErrCode(4);
                        }
                        val.setErrCode(4);
                        this.log.error((Object)("Monitor method '" + key + "' threw " + "a runtime exception: " + tExc.getMessage()), tExc);
                    }
                }
            }
            res[i] = val;
        }
        return res;
    }

    public String[] getMonitorKeys() throws AgentMonitorException {
        return this.methodKeys;
    }

    public int[] getMonitorTypes() throws AgentMonitorException {
        return this.methodTypes;
    }
}

