/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.stats;

import java.io.File;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.stats.AgentStatsCollector;
import org.hyperic.hq.stats.AbstractStatsCollector;
import org.hyperic.hq.stats.AbstractStatsWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentStatsWriter
extends AbstractStatsWriter {
    private static final String PREFIX = "agentstats";
    private ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private AgentConfig config;

    public AgentStatsWriter(AgentConfig config) {
        super((AbstractStatsCollector)AgentStatsCollector.getInstance(), AbstractStatsWriter.Retention.MONTHLY, PREFIX);
        this.config = config;
    }

    protected ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long millis) {
        return this.executor.scheduleWithFixedDelay(task, millis, millis, TimeUnit.MILLISECONDS);
    }

    protected String getAndSetupBasedir() {
        File logDir = this.config.getLogDir();
        File statsDir = new File(logDir, PREFIX);
        statsDir.mkdir();
        return statsDir.getAbsolutePath();
    }

    public void stopWriter() {
        this.executor.shutdown();
    }
}

