/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.postgresql.PostgreSQL;
import org.hyperic.hq.product.JDBCControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.jdbc.DBUtil;

public abstract class ResourceControl
extends JDBCControlPlugin {
    private static Log log = LogFactory.getLog(ResourceControl.class);
    protected String db;

    protected final Class getDriver() throws ClassNotFoundException {
        return Class.forName("org.postgresql.Driver");
    }

    protected final Connection getConnection(String url, String user, String password) throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    public final void configure(ConfigResponse config) throws PluginException {
        log.debug((Object)("[configure] config=" + config));
        String DB = config.getValue("db");
        String schema = config.getValue("schema");
        this.url = PostgreSQL.prepareUrl(config.toProperties(), DB);
        this.user = config.getValue("postgresql.user");
        this.password = config.getValue("postgresql.pass");
        this.db = config.getValue("db");
        this.table = schema + "." + config.getValue("table");
        this.index = schema + "." + config.getValue("index");
    }

    public final void doAction(String action) throws PluginException {
        this.doAction(action, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(String query) throws PluginException {
        Connection conn = null;
        Statement stmt = null;
        this.setResult(-1);
        try {
            conn = this.getConnection(this.url, this.user, this.password);
            stmt = conn.createStatement();
            stmt.executeQuery(query);
            this.setResult(0);
        }
        catch (SQLException e) {
            try {
                this.setMessage("Error executing query:'" + query + "' > " + e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)this.getLog(), conn, stmt, null);
                throw throwable;
            }
            DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, (Statement)stmt, null);
        }
        DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, (Statement)stmt, null);
    }
}

