/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.mysql_stats;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hyperic.hq.product.JDBCControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.jdbc.DBUtil;

public class MySqlStatsControlPlugin
extends JDBCControlPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(String action) throws PluginException {
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block5: {
            String query = this.getQuery(action);
            conn = null;
            stmt = null;
            rs = null;
            this.setResult(-1);
            try {
                conn = this.getConnection(this.url, this.user, this.password);
                stmt = conn.createStatement();
                rs = stmt.executeQuery(query);
                this.setResult(0);
                Map columns = this.getColumnMap(rs);
                StringBuffer result = new StringBuffer();
                if (rs == null || !rs.next()) break block5;
                for (Map.Entry entry : columns.entrySet()) {
                    String name = (String)entry.getKey();
                    Integer col = (Integer)entry.getValue();
                    result.append(name).append(": ").append(rs.getString(col)).append('\n');
                }
                this.setMessage("Result: " + result.toString());
            }
            catch (SQLException e) {
                try {
                    this.setMessage(e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtil.closeJDBCObjects((Object)this.getLog(), conn, stmt, rs);
                    throw throwable;
                }
                DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, (Statement)stmt, rs);
            }
            DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, (Statement)stmt, (ResultSet)rs);
            return;
        }
        DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, (Statement)stmt, (ResultSet)rs);
        throw new PluginException("Action '" + action + "' did not execute properly " + "");
    }

    private Map getColumnMap(ResultSet rs) throws SQLException {
        HashMap<String, Integer> rtn = new HashMap<String, Integer>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = rsmd.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String name = rsmd.getColumnName(i);
            int col = rs.findColumn(name);
            rtn.put(name, new Integer(col));
        }
        return rtn;
    }

    private String getQuery(String action) throws PluginException {
        String table = this.config.getValue("table");
        String dbname = this.config.getValue("database");
        if (action.equals("Analyze")) {
            return "ANALYZE TABLE " + dbname + "." + table;
        }
        if (action.equals("Check")) {
            return "CHECK TABLE " + dbname + "." + table;
        }
        if (action.equals("Optimize")) {
            return "OPTIMIZE TABLE " + dbname + "." + table;
        }
        if (action.equals("Repair")) {
            return "REPAIR TABLE " + dbname + "." + table;
        }
        throw new PluginException("Action '" + action + "' not supported");
    }

    protected Connection getConnection(String url, String user, String pass) throws SQLException {
        Properties props = new Properties();
        props.setProperty("user", user);
        props.setProperty("password", pass);
        return DriverManager.getConnection(url, props);
    }

    protected Class getDriver() throws ClassNotFoundException {
        return Class.forName("com.mysql.jdbc.Driver");
    }
}

