
#ifndef __COVALENT_SNMP_SCONFIG_H__
#define __COVALENT_SNMP_SCONFIG_H__

#define CONDUCTOR_MODULE_NAME	"covalent-snmp-v13.c"

typedef int (snmp_logger)(snmp_generic_log_record *data);
typedef int (mib_init)(server_rec *s, pool *p);
typedef void (notification)(int trap, int specific, oid *enterprise,
                             int enterprise_length, struct variable_list *vars);

/*
 * In case we need to make extensions to this API for other modules to register
 * things with the SNMP-agent are for the SNMP agent to make info available
 * we must keep track of a API-version.
 * We also must now not rotate the currently defined items in the
 * 'covalent_snmp_sconfig' and the 'external_mib_subtree'.
 */

#define CONDUCTOR_API_VERSION	1

typedef struct {
    oid *base_oid;
    size_t base_oid_length;
    struct variables *variables;
    size_t variable_size;
    int variables_amount;
    mib_init *init;
    snmp_logger *logging_sink;
} external_mib_subtree;

typedef struct {
    int wwwServiceIndex;
    int api_version;
    snmp_logger *snmp_logger;
    notification *invoke_notification;
    array_header *external_mib_subtrees;
} covalent_snmp_sconfig;

void *covalent_snmp_create_sconf(pool *p, server_rec *s);
void *covalent_snmp_merge_sconf(pool *p, void *server1_conf, void *server2_conf);
int set_sconfig_wwwServiceIndex(server_rec *s, int index);
int get_sconfig_wwwServiceIndex(server_rec *s);
int init_external_mib_modules(server_rec *s, pool *p);
void covalent_snmp_setup_sconf_for_vhosts(pool *p, server_rec *s);

#endif /* __COVALENT_SNMP_SCONFIG_H__ */
