#ifndef __APACHE_MPM_MIB_H__
#define __APACHE_MPM_MIB_H__

#ifdef COVALENT_APACHE_MPM_MIB
void init_covalent_apache_mpm_mib(void);
#else /* COVALENT_APACHE_MPM_MIB */
#define init_covalent_apache_mpm_mib()
#endif /* COVALENT_APACHE_MPM_MIB */

/*
 * Following portion is internal to the MIB module implementation.
 */
#ifdef APACHE_MPM_MIB_PRIVATE

#ifdef COVALENT_APACHE_MPM_MIB_WRITE
/* The function definition for the SNMP-SET. */
WriteMethod write_ctApacheMPMEntry;

/* Enable the SNMP-SET. */
#define WRITE_CTAPACHEMPMENTRY	write_ctApacheMPMEntry

/* variables used to temporary storage during SNMP-SET. */
extern int shadow_daemons_limit;
extern int shadow_daemons_min_free;
extern int shadow_daemons_max_free;
extern int shadow_max_requests_per_child;

#else
/* Disable the SNMP-SET. */
#define WRITE_CTAPACHEMPMENTRY	NULL
#endif /* COVALENT_APACHE_MPM_MIB_WRITE */

/* Define the apache server mpm table columns */
#define CTAPACHEMPMDESCR                     1
#define CTAPACHEMPMFORKING                   2
#define CTAPACHEMPMTHREADING                 3
#define CTAPACHEMPMDAEMONSLIMIT              4
#define CTAPACHEMPMTHREADSLIMIT              5
#define CTAPACHEMPMMAXDAEMONS                6
#define CTAPACHEMPMMAXTHREADS                7
#define CTAPACHEMPMMINSPAREDAEMONS           8
#define CTAPACHEMPMMINSPARETHREADS           9
#define CTAPACHEMPMMAXSPAREDAEMONS           10
#define CTAPACHEMPMMAXSPARETHREADS           11
#define CTAPACHEMPMMAXREQUESTPERDAEMON       12

#endif /* APACHE_MPM_MIB_PRIVATE */

#endif /* __APACHE_MPM_MIB_H__ */
