/* Apache includes */
#include <httpd.h>

/* SNMP includes */
#include "ucd-snmp-config.h"
#include "asn1.h"
#include "snmp.h"
#include "snmp_api.h"
#include "snmp_impl.h"
#include "snmp_debug.h"
#include "snmp_vars.h"
#include "var_struct.h"

/* includes */
#include "covalent-snmp-config.h"
#include "snmpcommon/snmpcommon.h"
#include "www-extensions-mib.h"

#ifndef SNMP_MIN
#define SNMP_MIN(a,b)   (((a)<(b)) ? (a) : (b))
#endif

#define NEXT	FALSE
#define EXACT	TRUE
#define INDEX	2

#ifdef COVALENT_WWW_EXTENSIONS_MAPPING_GROUP

FindVarMethod var_wwwForwardMappingEntry;
FindVarMethod var_wwwReverseMappingEntry;
static server_rec *get_wwwServiceIndexMapping_row(struct variable *vp,
        oid *name, size_t *namelength, int exact, server_rec *server);

#define CTWWWFORWARDMAPPINGDESCR 1
#define CTWWWREVERSEMAPPINGDESCR 1

static server_rec *
get_wwwServiceIndexMapping_row(struct variable *vp,
	oid *name, size_t *namelength,
	int exact, server_rec *server)
{
oid *ptr;

    ptr = &(vp->name[ vp->namelen++ ]);
    *ptr = 1;
    while (server) {
        switch (exact) {
        case NEXT:
            if (0 > snmp_oid_compare(name, *namelength,
                                     vp->name, vp->namelen)) {
                return(server);
            }
            break;
        case EXACT:
            if (0 == snmp_oid_compare(name, *namelength,
                                      vp->name, vp->namelen)) {
                return(server);
            }
            break;
        case INDEX:
            if (0 == snmp_oid_compare(name, SNMP_MIN(*namelength,vp->namelen),
                                      vp->name, SNMP_MIN(*namelength,vp->namelen))) {
                return(server);
            }
            break;
        }
	(*ptr)++;
        server = server->next;
    }
    return(NULL);
}

unsigned char *
var_wwwForwardMappingEntry(struct variable *vp,
    oid *name, size_t *length,
    int exact, size_t *var_len, WriteMethod **write_method)
{
server_rec *service;
int result;
static unsigned char *empty_string = "";

    service = get_wwwServiceIndexMapping_row(vp, name, length, exact,
                                        get_www_service_root());
    if (!service) {
	return NULL; 
    }
    vp->name[ vp->namelen++ ] = get_appl_index();
    result = snmp_oid_compare(name, *length, vp->name, vp->namelen);
    if ((exact && (result != 0)) || (!exact && (result >= 0))) {
        return(NULL);
    }

    *length = vp->namelen;
    memcpy( (char *)name,(char *)vp->name, *length * sizeof(oid));
    *write_method = 0;
    *var_len = 0;

    switch (vp->magic) {
	case CTWWWFORWARDMAPPINGDESCR:
	    return (unsigned char *) empty_string;
    }
    return(NULL);
}


unsigned char *
var_wwwReverseMappingEntry(struct variable *vp,
    oid *name, size_t *length,
    int exact, size_t *var_len, WriteMethod **write_method)
{
server_rec *service;
static char *empty_string = "";

    vp->name[ vp->namelen++ ] = get_appl_index();
    service = get_wwwServiceIndexMapping_row(vp, name, length,
                                        exact, get_www_service_root());
    if (!service) {
	return NULL; 
    }

    *length = vp->namelen;
    memcpy( (char *)name,(char *)vp->name, *length * sizeof(oid));
    *write_method = 0;
    *var_len = 0;

    switch (vp->magic) {
	case CTWWWREVERSEMAPPINGDESCR:
	    return (unsigned char *) empty_string;
    }
    return(NULL);
}

oid wwwForwardMappingEntry_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 15, 1, 1, 1, 1 };
struct variable2 wwwForwardMappingEntry_variables[] = {
    { CTWWWFORWARDMAPPINGDESCR, ASN_OCTET_STR, RONLY, var_wwwForwardMappingEntry, 1, { 1 }},
};

oid wwwReverseMappingEntry_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 15, 1, 1, 2, 1 };
struct variable2 wwwReverseMappingEntry_variables[] = {
    { CTWWWREVERSEMAPPINGDESCR, ASN_OCTET_STR, RONLY, var_wwwReverseMappingEntry, 1, { 1 }},
};

void init_covalent_www_extensions_mapping_group()
{
    REGISTER_MIB("www-mib/wwwForwardMappingTable",
                          wwwForwardMappingEntry_variables,
                          variable2, wwwForwardMappingEntry_oid);
    REGISTER_MIB("www-mib/wwwReverseMappingTable",
                          wwwReverseMappingEntry_variables,
                          variable2, wwwReverseMappingEntry_oid);
}

#endif /* COVALENT_WWW_EXTENSIONS_MAPPING_GROUP */

