/*
 * covalent_sdbm - ndbm work-alike hashed database library
 * based on Per-Ake Larson's Dynamic Hashing algorithms. BIT 18 (1978).
 * author: oz@nexus.yorku.ca
 * status: public domain. 
 */
#define DBLKSIZ 4096
#define PBLKSIZ 1024
#define PAIRMAX 1008			/* arbitrary on PBLKSIZ-N */
#define SPLTMAX	10			/* maximum allowed splits */
					/* for a single insertion */
#ifdef VMS
#define DIRFEXT	".covalent_sdbm_dir"
#else
#define DIRFEXT	".dir"
#endif
#define PAGFEXT	".pag"

typedef struct {
	int dirf;		       /* directory file descriptor */
	int pagf;		       /* page file descriptor */
	int flags;		       /* status/error flags, see below */
	long maxbno;		       /* size of dirfile in bits */
	long curbit;		       /* current bit number */
	long hmask;		       /* current hash mask */
	long blkptr;		       /* current block for nextkey */
	int keyptr;		       /* current key for nextkey */
	long blkno;		       /* current page to read/write */
	long pagbno;		       /* current page in pagbuf */
	char pagbuf[PBLKSIZ];	       /* page file block buffer */
	long dirbno;		       /* current block in dirbuf */
	char dirbuf[DBLKSIZ];	       /* directory file block buffer */
} DBM;

#define DBM_RDONLY	0x1	       /* data base open read-only */
#define DBM_IOERR	0x2	       /* data base I/O error */

/*
 * utility macros
 */
#define covalent_sdbm_rdonly(db)		((db)->flags & DBM_RDONLY)
#define covalent_sdbm_error(db)		((db)->flags & DBM_IOERR)

#define covalent_sdbm_clearerr(db)	((db)->flags &= ~DBM_IOERR)  /* ouch */

#define covalent_sdbm_dirfno(db)	((db)->dirf)
#define covalent_sdbm_pagfno(db)	((db)->pagf)

typedef struct {
	char *dptr;
	int dsize;
} datum;


#if defined(__STDC__) || defined(__cplusplus) || defined(CAN_PROTOTYPE)
#define proto(p) p
#else
#define proto(p) ()
#endif

/*
 * flags to covalent_sdbm_store
 */
#define DBM_INSERT	0
#define DBM_REPLACE	1

/*
 * ndbm interface
 */
extern DBM *covalent_sdbm_open proto((char *, int, int));
extern void covalent_sdbm_close proto((DBM *));
extern datum covalent_sdbm_fetch proto((DBM *, datum));
extern int covalent_sdbm_delete proto((DBM *, datum));
extern int covalent_sdbm_store proto((DBM *, datum, datum, int));
extern datum covalent_sdbm_firstkey proto((DBM *));
extern datum covalent_sdbm_nextkey proto((DBM *));
extern int covalent_sdbm_exists proto((DBM *, datum));

/*
 * other
 */
extern DBM *covalent_sdbm_prep proto((char *, char *, int, int));
extern long covalent_sdbm_hash proto((char *, int));

#ifndef SDBM_ONLY
#define dbm_open covalent_sdbm_open
#define dbm_close covalent_sdbm_close
#define dbm_fetch covalent_sdbm_fetch
#define dbm_store covalent_sdbm_store
#define dbm_delete covalent_sdbm_delete
#define dbm_firstkey covalent_sdbm_firstkey
#define dbm_nextkey covalent_sdbm_nextkey
#define dbm_error covalent_sdbm_error
#define dbm_clearerr covalent_sdbm_clearerr
#endif
