/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class Accessor {
    static final int FIXED_CHAR = 999;
    static final int CHAR = 96;
    static final int VARCHAR = 1;
    static final int VCS = 9;
    static final int LONG = 8;
    static final int NUMBER = 2;
    static final int VARNUM = 6;
    static final int BINARY_FLOAT = 100;
    static final int BINARY_DOUBLE = 101;
    static final int RAW = 23;
    static final int VBI = 15;
    static final int LONG_RAW = 24;
    static final int ROWID = 104;
    static final int RESULT_SET = 102;
    static final int RSET = 116;
    static final int DATE = 12;
    static final int BLOB = 113;
    static final int CLOB = 112;
    static final int BFILE = 114;
    static final int NAMED_TYPE = 109;
    static final int REF_TYPE = 111;
    static final int TIMESTAMP = 180;
    static final int TIMESTAMPTZ = 181;
    static final int TIMESTAMPLTZ = 231;
    static final int INTERVALYM = 182;
    static final int INTERVALDS = 183;
    static final int UROWID = 208;
    static final int PLSQL_INDEX_TABLE = 998;
    static final int T2S_OVERLONG_RAW = 997;
    static final int SET_CHAR_BYTES = 996;
    static final int NULL_TYPE = 995;
    static final int DML_RETURN_PARAM = 994;
    static final int ONLY_FORM_USABLE = 0;
    static final int NOT_USABLE = 1;
    static final int NO_NEED_TO_PREPARE = 2;
    static final int NEED_TO_PREPARE = 3;
    OracleStatement statement;
    boolean outBind;
    int internalType;
    int internalTypeMaxLength;
    boolean isStream = false;
    boolean isColumnNumberAware = false;
    short formOfUse = (short)2;
    OracleType internalOtype;
    int externalType;
    String internalTypeName;
    String columnName;
    int describeType;
    int describeMaxLength;
    boolean nullable;
    int precision;
    int scale;
    int flags;
    int contflag;
    int total_elems;
    OracleType describeOtype;
    String describeTypeName;
    int definedColumnType = 0;
    int definedColumnSize = 0;
    int oacmxl = 0;
    short udskpos = (short)-1;
    int lobPrefetchSizeForThisColumn = -1;
    long[] prefetchedLobSize = null;
    int[] prefetchedLobChunkSize = null;
    byte[] prefetchedClobFormOfUse = null;
    byte[][] prefetchedLobData = null;
    char[][] prefetchedLobCharData = null;
    int[] prefetchedLobDataL = null;
    OracleResultSetMetaData.SecurityAttribute securityAttribute;
    byte[] rowSpaceByte = null;
    char[] rowSpaceChar = null;
    short[] rowSpaceIndicator = null;
    static final byte DATA_UNAUTHORIZED = 1;
    byte[] rowSpaceMetaData = null;
    int columnIndex = 0;
    int lengthIndex = 0;
    int indicatorIndex = 0;
    int metaDataIndex = 0;
    int columnIndexLastRow = 0;
    int lengthIndexLastRow = 0;
    int indicatorIndexLastRow = 0;
    int metaDataIndexLastRow = 0;
    int byteLength = 0;
    int charLength = 0;
    int defineType;
    boolean isDMLReturnedParam = false;
    int lastRowProcessed = 0;
    boolean isUseLess = false;
    int physicalColumnIndex = -2;
    boolean isNullByDescribe = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_12:16:40_PDT_2010";
    public static final boolean TRACE = false;

    Accessor() {
    }

    void setOffsets(int n2) {
        this.columnIndex = this.statement.defineByteSubRange;
        this.statement.defineByteSubRange = this.columnIndex + n2 * this.byteLength;
    }

    void init(OracleStatement oracleStatement, int n2, int n3, short s2, boolean bl) throws SQLException {
        this.statement = oracleStatement;
        this.outBind = bl;
        this.internalType = n2;
        this.defineType = n3;
        this.formOfUse = s2;
    }

    abstract void initForDataAccess(int var1, int var2, String var3) throws SQLException;

    void initForDescribe(int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s2) throws SQLException {
        this.describeType = n2;
        this.describeMaxLength = n3;
        this.nullable = bl;
        this.precision = n5;
        this.scale = n6;
        this.flags = n4;
        this.contflag = n7;
        this.total_elems = n8;
        this.formOfUse = s2;
    }

    void initForDescribe(int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s2, String string) throws SQLException {
        this.describeTypeName = string;
        this.describeOtype = null;
        this.initForDescribe(n2, n3, bl, n4, n5, n6, n7, n8, s2);
    }

    OracleInputStream initForNewRow() throws SQLException {
        this.unimpl("initForNewRow");
        return null;
    }

    int useForDataAccessIfPossible(int n2, int n3, int n4, String string) throws SQLException {
        int n5 = 3;
        int n6 = 0;
        int n7 = 0;
        if (this.internalType != 0) {
            if (this.internalType != n2) {
                n5 = 0;
            } else if (this.rowSpaceIndicator != null) {
                n6 = this.byteLength;
                n7 = this.charLength;
            }
        }
        if (n5 == 3) {
            this.initForDataAccess(n3, n4, string);
            if (!this.outBind && n6 >= this.byteLength && n7 >= this.charLength) {
                n5 = 2;
            }
        }
        return n5;
    }

    boolean useForDescribeIfPossible(int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s2, String string) throws SQLException {
        if (this.externalType == 0 && n2 != this.describeType) {
            return false;
        }
        this.initForDescribe(n2, n3, bl, n4, n5, n6, n7, n8, s2, string);
        return true;
    }

    void setFormOfUse(short s2) {
        this.formOfUse = s2;
    }

    void updateColumnNumber(int n2) {
    }

    public String toString() {
        return super.toString() + ", statement=" + this.statement + ", outBind=" + this.outBind + ", internalType=" + this.internalType + ", internalTypeMaxLength=" + this.internalTypeMaxLength + ", isStream=" + this.isStream + ", formOfUse=" + this.formOfUse + ", internalOtype=" + this.internalOtype + ", externalType=" + this.externalType + ", internalTypeName=" + this.internalTypeName + ", columnName=" + this.columnName + ", describeType=" + this.describeType + ", describeMaxLength=" + this.describeMaxLength + ", nullable=" + this.nullable + ", precision=" + this.precision + ", scale=" + this.scale + ", flags=" + this.flags + ", contflag=" + this.contflag + ", total_elems=" + this.total_elems + ", describeOtype=" + this.describeOtype + ", describeTypeName=" + this.describeTypeName + ", rowSpaceByte=" + this.rowSpaceByte + ", rowSpaceChar=" + this.rowSpaceChar + ", rowSpaceIndicator=" + this.rowSpaceIndicator + ", columnIndex=" + this.columnIndex + ", lengthIndex=" + this.lengthIndex + ", indicatorIndex=" + this.indicatorIndex + ", byteLength=" + this.byteLength + ", charLength=" + this.charLength;
    }

    void unimpl(String string) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, string + " not implemented for " + this.getClass());
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    boolean getBoolean(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return false;
        }
        this.unimpl("getBoolean");
        return false;
    }

    byte getByte(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return 0;
        }
        this.unimpl("getByte");
        return 0;
    }

    OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        if (this.rowSpaceMetaData == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byte by = this.rowSpaceMetaData[this.metaDataIndex + 1 * n2];
        if ((by & 1) != 0) {
            return OracleResultSet.AuthorizationIndicator.UNAUTHORIZED;
        }
        if (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED || this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.NONE) {
            return OracleResultSet.AuthorizationIndicator.NONE;
        }
        return OracleResultSet.AuthorizationIndicator.UNKNOWN;
    }

    short getShort(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return 0;
        }
        this.unimpl("getShort");
        return 0;
    }

    int getInt(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return 0;
        }
        this.unimpl("getInt");
        return 0;
    }

    long getLong(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return 0L;
        }
        this.unimpl("getLong");
        return 0L;
    }

    float getFloat(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return 0.0f;
        }
        this.unimpl("getFloat");
        return 0.0f;
    }

    double getDouble(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return 0.0;
        }
        this.unimpl("getDouble");
        return 0.0;
    }

    BigDecimal getBigDecimal(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getBigDecimal");
        return null;
    }

    BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getBigDecimal");
        return null;
    }

    String getString(int n2) throws SQLException {
        return null;
    }

    Date getDate(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getDate");
        return null;
    }

    Date getDate(int n2, Calendar calendar) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getDate");
        return null;
    }

    Time getTime(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getTime");
        return null;
    }

    Time getTime(int n2, Calendar calendar) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getTime");
        return null;
    }

    Timestamp getTimestamp(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getTimestamp");
        return null;
    }

    Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getTimestamp");
        return null;
    }

    byte[] privateGetBytes(int n2) throws SQLException {
        return this.getBytes(n2);
    }

    byte[] getBytes(int n2) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
        }
        return byArray;
    }

    InputStream getAsciiStream(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getAsciiStream");
        return null;
    }

    InputStream getUnicodeStream(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getUnicodeStream");
        return null;
    }

    InputStream getBinaryStream(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getBinaryStream");
        return null;
    }

    Object getObject(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getObject");
        return null;
    }

    ResultSet getCursor(int n2) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    Datum getOracleObject(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getOracleObject");
        return null;
    }

    ROWID getROWID(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    NUMBER getNUMBER(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getNUMBER");
        return null;
    }

    DATE getDATE(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getDATE");
        return null;
    }

    ARRAY getARRAY(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getARRAY");
        return null;
    }

    STRUCT getSTRUCT(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getSTRUCT");
        return null;
    }

    OPAQUE getOPAQUE(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getOPAQUE");
        return null;
    }

    REF getREF(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getREF");
        return null;
    }

    CHAR getCHAR(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getCHAR");
        return null;
    }

    RAW getRAW(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getRAW");
        return null;
    }

    BLOB getBLOB(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getBLOB");
        return null;
    }

    CLOB getCLOB(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getCLOB");
        return null;
    }

    BFILE getBFILE(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getBFILE");
        return null;
    }

    CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        return customDatumFactory.create(datum, 0);
    }

    ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        return oRADataFactory.create(datum, 0);
    }

    Object getObject(int n2, Map map) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getObject");
        return null;
    }

    Reader getCharacterStream(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getCharacterStream");
        return null;
    }

    INTERVALYM getINTERVALYM(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getINTERVALYM");
        return null;
    }

    INTERVALDS getINTERVALDS(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getINTERVALDS");
        return null;
    }

    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getTIMESTAMP");
        return null;
    }

    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getTIMESTAMPTZ");
        return null;
    }

    TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getTIMESTAMPLTZ");
        return null;
    }

    URL getURL(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getURL");
        return null;
    }

    Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getOraclePlsqlIndexTable");
        return null;
    }

    boolean isNull(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.rowSpaceIndicator[this.indicatorIndex + n2] == -1;
    }

    void setNull(int n2, boolean bl) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.rowSpaceIndicator[this.indicatorIndex + n2] = (short)(bl ? -1 : 0);
    }

    void fetchNextColumns() throws SQLException {
    }

    void calculateSizeTmpByteArray() {
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void copyRow() throws SQLException, IOException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    int readStream(byte[] byArray, int n2) throws SQLException, IOException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void initMetadata() throws SQLException {
    }

    void setDisplaySize(int n2) throws SQLException {
        this.describeMaxLength = n2;
    }

    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n2, int n3) throws SQLException {
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.statement.getConnectionDuringExceptionHandling();
    }
}

