/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.control.agent.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPIInfo;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.bizapp.client.ControlCallbackClient;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.bizapp.shared.lather.ControlSendCommandResult_args;
import org.hyperic.hq.control.agent.ControlCommandsAPI;
import org.hyperic.hq.control.agent.client.ControlCommandsClient;
import org.hyperic.hq.control.agent.commands.ControlPluginAdd_args;
import org.hyperic.hq.control.agent.commands.ControlPluginAdd_result;
import org.hyperic.hq.control.agent.commands.ControlPluginCommand_args;
import org.hyperic.hq.control.agent.commands.ControlPluginCommand_result;
import org.hyperic.hq.control.agent.commands.ControlPluginRemove_args;
import org.hyperic.hq.control.agent.commands.ControlPluginRemove_result;
import org.hyperic.hq.control.agent.server.ControlCommandsService;
import org.hyperic.hq.product.ControlPluginManager;
import org.hyperic.util.MultiRuntimeException;
import org.hyperic.util.config.ConfigResponse;

public class ControlCommandsServer
implements AgentServerHandler {
    private static final String PROP_BACKUPDIR = "file_backup";
    private ControlCommandsAPI verAPI = new ControlCommandsAPI();
    private Log log = LogFactory.getLog(ControlCommandsServer.class);
    private AgentConfig bootConfig = null;
    private AgentStorageProvider storage;
    private ControlCommandsService controlCommandsService;

    public AgentAPIInfo getAPIInfo() {
        return this.verAPI;
    }

    public String[] getCommandSet() {
        return ControlCommandsAPI.commandSet;
    }

    public AgentRemoteValue dispatchCommand(String cmd, AgentRemoteValue args, InputStream in, OutputStream out) throws AgentRemoteException {
        if (cmd.equals("control:controlPluginAdd")) {
            ControlPluginAdd_args ca = new ControlPluginAdd_args(args);
            return this.controlPluginAdd(ca);
        }
        if (cmd.equals("control:controlPluginCommand")) {
            ControlPluginCommand_args ca = new ControlPluginCommand_args(args);
            return this.controlPluginCommand(ca);
        }
        if (cmd.equals("control:controlPluginRemove")) {
            ControlPluginRemove_args ca = new ControlPluginRemove_args(args);
            return this.controlPluginRemove(ca);
        }
        throw new AgentRemoteException("Unexpected command: " + cmd);
    }

    public void startup(AgentDaemon agent) throws AgentStartException {
        AgentTransportLifecycle agentTransportLifecycle;
        ControlCallbackClient client;
        ControlPluginManager controlManager;
        this.bootConfig = agent.getBootConfig();
        Properties bootProps = this.bootConfig.getBootProperties();
        try {
            this.storage = agent.getStorageProvider();
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get storage provider: " + e.getMessage());
        }
        try {
            controlManager = (ControlPluginManager)agent.getPluginManager("control");
            client = this.setupClient();
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to load control jars: " + e.getMessage());
        }
        this.controlCommandsService = new ControlCommandsService(controlManager, client);
        try {
            agentTransportLifecycle = agent.getAgentTransportLifecycle();
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get agent transport lifecycle: " + e.getMessage());
        }
        this.log.info((Object)"Registering Control Commands Service with Agent Transport");
        try {
            agentTransportLifecycle.registerService(ControlCommandsClient.class, (Object)this.controlCommandsService);
        }
        catch (Exception e) {
            throw new AgentStartException("Failed to register Control Commands Service.", e);
        }
        this.log.info((Object)"Control Commands Server started up");
    }

    public final void postInitActions() throws AgentStartException {
        try {
            this.processPersistedControlResponses();
        }
        catch (Exception e) {
            throw new AgentStartException("Failed to send persisted control response to the server.", e);
        }
    }

    private final void processPersistedControlResponses() throws Exception {
        File persistedControlResponsesDir = new File(AgentConfig.PERSISTED_CONTROL_RESPONSES_DIR);
        File[] tempControlResponses = null;
        if (!persistedControlResponsesDir.exists() || (tempControlResponses = persistedControlResponsesDir.listFiles()) == null) {
            this.log.info((Object)"No persisted Control responses were found");
            return;
        }
        final File[] controlResponses = tempControlResponses;
        Runnable persistControlResponsesActionSender = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public final void run() {
                MultiRuntimeException thrown = null;
                ObjectInputStream ois = null;
                ControlSendCommandResult_args controlResponse = null;
                int counter = 0;
                boolean errorOccured = false;
                ControlCallbackClient client = ControlCommandsServer.this.controlCommandsService.getClient();
                for (File controlResponseFile : controlResponses) {
                    ois = new ObjectInputStream(new FileInputStream(controlResponseFile));
                    controlResponse = (ControlSendCommandResult_args)ois.readObject();
                    ControlCommandsServer.this.log.info((Object)("About to post persisted control response " + controlResponse.getId()));
                    client.controlSendCommandResult(controlResponse);
                    ++counter;
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (IOException ioe) {
                        thrown = MultiRuntimeException.newMultiRuntimeException((MultiRuntimeException)thrown, (Throwable)ioe, (String)("Error while closing FileInputStream" + controlResponseFile));
                    }
                    if (!errorOccured) {
                        ControlCommandsServer.this.log.info((Object)("Deleting Persisted Control Response file " + controlResponseFile + ". Delete Successed: " + controlResponseFile.delete()));
                    }
                    errorOccured = false;
                    continue;
                    catch (Throwable t) {
                        try {
                            t.printStackTrace();
                            thrown = MultiRuntimeException.newMultiRuntimeException(thrown, (Throwable)t, (String)("Deserialization Error for Persisted Control Response " + controlResponseFile));
                            errorOccured = true;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (ois != null) {
                                    ois.close();
                                }
                            }
                            catch (IOException ioe) {
                                thrown = MultiRuntimeException.newMultiRuntimeException(thrown, (Throwable)ioe, (String)("Error while closing FileInputStream" + controlResponseFile));
                            }
                            if (!errorOccured) {
                                ControlCommandsServer.this.log.info((Object)("Deleting Persisted Control Response file " + controlResponseFile + ". Delete Successed: " + controlResponseFile.delete()));
                            }
                            errorOccured = false;
                            throw throwable;
                        }
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                        }
                        catch (IOException ioe) {
                            thrown = MultiRuntimeException.newMultiRuntimeException((MultiRuntimeException)thrown, (Throwable)ioe, (String)("Error while closing FileInputStream" + controlResponseFile));
                        }
                        if (!errorOccured) {
                            ControlCommandsServer.this.log.info((Object)("Deleting Persisted Control Response file " + controlResponseFile + ". Delete Successed: " + controlResponseFile.delete()));
                        }
                        errorOccured = false;
                    }
                }
                ControlCommandsServer.this.log.info((Object)("Successfully sent " + counter + " persisted control response(s), while encountered errors for " + (thrown != null ? thrown.size() : 0)));
                if (thrown != null) {
                    ControlCommandsServer.this.log.error((Object)thrown);
                }
            }
        };
        Thread t = new Thread(persistControlResponsesActionSender, "PersistedControlResponses_Sender");
        t.start();
    }

    public void shutdown() {
        this.log.info((Object)"Control Commands Server shut down");
    }

    private ControlCallbackClient setupClient() throws AgentStartException {
        StorageProviderFetcher fetcher = new StorageProviderFetcher(this.storage);
        return new ControlCallbackClient((ProviderFetcher)fetcher);
    }

    private ControlPluginAdd_result controlPluginAdd(ControlPluginAdd_args args) throws AgentRemoteException {
        ConfigResponse config = args.getConfigResponse();
        String name = args.getName();
        String type = args.getType();
        this.controlCommandsService.controlPluginAdd(name, type, config);
        ControlPluginAdd_result result = new ControlPluginAdd_result();
        return result;
    }

    private ControlPluginCommand_result controlPluginCommand(ControlPluginCommand_args args) throws AgentRemoteException {
        String pluginName = args.getPluginName();
        String pluginType = args.getPluginType();
        String id = args.getId();
        String pluginAction = args.getPluginAction();
        String[] pluginArgs = args.getArgs();
        this.controlCommandsService.controlPluginCommand(pluginName, pluginType, id, pluginAction, pluginArgs);
        return new ControlPluginCommand_result();
    }

    private ControlPluginRemove_result controlPluginRemove(ControlPluginRemove_args args) throws AgentRemoteException {
        String pluginName = args.getPluginName();
        this.controlCommandsService.controlPluginRemove(pluginName);
        return new ControlPluginRemove_result();
    }
}

