/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPI;
import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.AgentStreamPair;
import org.hyperic.hq.agent.client.SocketStreamPair;
import org.hyperic.util.timer.StopWatch;

public class AgentConnection {
    private static final Log log = LogFactory.getLog(AgentConnection.class);
    private static final int MAX_RETRIES = 5;
    private static final long SLEEP_TIME = 3000L;
    private static final int SOCKET_TIMEOUT = 60000;
    private String _agentAddress;
    private int _agentPort;
    private AgentAPI _agentAPI;

    public AgentConnection(String agentAddress, int agentPort) {
        this._agentAddress = agentAddress;
        this._agentPort = agentPort;
        this._agentAPI = new AgentAPI();
    }

    public String getAgentAddress() {
        return this._agentAddress;
    }

    public int getAgentPort() {
        return this._agentPort;
    }

    protected Socket getSocket() throws IOException {
        Socket s;
        try {
            s = new Socket(this._agentAddress, this._agentPort);
        }
        catch (IOException exc) {
            String msg = "Error connecting to agent @ (" + this._agentAddress + ":" + this._agentPort + "): " + exc.getMessage();
            IOException toThrow = new IOException(msg);
            toThrow.initCause(exc);
            throw toThrow;
        }
        s.setSoTimeout(60000);
        return s;
    }

    public AgentRemoteValue sendCommand(String cmdName, int cmdVersion, AgentRemoteValue arg) throws AgentRemoteException, AgentConnectionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this._agentAddress + ":" + this._agentPort + " -> " + cmdName));
        }
        AgentStreamPair sPair = this.sendCommandHeaders(cmdName, cmdVersion, arg);
        return this.getCommandResult(sPair);
    }

    public AgentRemoteValue sendCommand(String cmdName, int cmdVersion, AgentRemoteValue arg, boolean withRetries) throws AgentRemoteException, AgentConnectionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this._agentAddress + ":" + this._agentPort + " -> " + cmdName));
        }
        AgentStreamPair sPair = this.sendCommandHeaders(cmdName, cmdVersion, arg, withRetries);
        return this.getCommandResult(sPair);
    }

    public AgentStreamPair sendCommandHeaders(String cmdName, int cmdVersion, AgentRemoteValue arg) throws AgentConnectionException {
        return this.sendCommandHeaders(cmdName, cmdVersion, arg, true);
    }

    private AgentStreamPair sendCommandHeaders(String cmdName, int cmdVersion, AgentRemoteValue arg, boolean withRetries) throws AgentConnectionException {
        StopWatch watch = new StopWatch();
        boolean debug = log.isDebugEnabled();
        try {
            if (debug) {
                watch.markTimeBegin("cmdName=" + cmdName);
            }
            if (withRetries) {
                AgentStreamPair agentStreamPair = this.sendCommandHeadersWithRetries(cmdName, cmdVersion, arg, 5);
                return agentStreamPair;
            }
            AgentStreamPair agentStreamPair = this.sendCommandHeadersWithRetries(cmdName, cmdVersion, arg, 1);
            return agentStreamPair;
        }
        catch (IOException exc) {
            throw new AgentConnectionException("Error sending argument: " + exc.getMessage() + ", cmd=" + cmdName, exc);
        }
        finally {
            if (debug) {
                watch.markTimeEnd("cmdName=" + cmdName);
            }
            if (debug) {
                log.debug((Object)watch);
            }
        }
    }

    private AgentStreamPair sendCommandHeadersWithRetries(String cmdName, int cmdVersion, AgentRemoteValue arg, int maxRetries) throws IOException {
        IOException ex = null;
        SocketStreamPair streamPair = null;
        Socket s = null;
        int tries = 0;
        while (tries++ < maxRetries) {
            try {
                s = this.getSocket();
                streamPair = new SocketStreamPair(s, s.getInputStream(), s.getOutputStream());
                DataOutputStream outputStream = new DataOutputStream(streamPair.getOutputStream());
                outputStream.writeInt(this._agentAPI.getVersion());
                outputStream.writeInt(cmdVersion);
                outputStream.writeUTF(cmdName);
                arg.toStream(outputStream);
                outputStream.flush();
                return streamPair;
            }
            catch (IOException e) {
                ex = e;
                this.close(s);
                if (tries >= maxRetries) break;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e2) {
                    log.debug((Object)e2, (Throwable)e2);
                }
            }
        }
        if (ex != null) {
            IOException toThrow = new IOException(ex.getMessage() + ", retried " + 5 + " times");
            toThrow.initCause(ex);
            throw toThrow;
        }
        return streamPair;
    }

    private void close(Socket s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException ex) {
            log.debug((Object)ex, (Throwable)ex);
        }
    }

    public AgentRemoteValue getCommandResult(AgentStreamPair inStreamPair) throws AgentRemoteException, AgentConnectionException {
        SocketStreamPair streamPair = (SocketStreamPair)inStreamPair;
        try {
            AgentRemoteValue result;
            DataInputStream inputStream = new DataInputStream(streamPair.getInputStream());
            int isException = inputStream.readInt();
            if (isException == 1) {
                String exceptionMsg = inputStream.readUTF();
                throw new AgentRemoteException(exceptionMsg);
            }
            AgentRemoteValue agentRemoteValue = result = AgentRemoteValue.fromStream(inputStream);
            return agentRemoteValue;
        }
        catch (EOFException exc) {
            throw new AgentConnectionException("EOF received from Agent");
        }
        catch (IOException exc) {
            throw new AgentConnectionException("Error reading result: " + exc.getMessage(), exc);
        }
        finally {
            this.close(streamPair);
        }
    }

    private void close(SocketStreamPair streamPair) {
        if (streamPair == null) {
            return;
        }
        try {
            streamPair.close();
        }
        catch (IOException e) {
            log.debug((Object)e, (Throwable)e);
        }
    }

    public void closeSocket() {
        try {
            this.getSocket().close();
        }
        catch (IOException e) {
            log.debug((Object)e, (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        return o instanceof AgentConnection && ((AgentConnection)o).getAgentAddress().equals(this.getAgentAddress()) && ((AgentConnection)o).getAgentPort() == this.getAgentPort();
    }

    public int hashCode() {
        return this.getAgentAddress().hashCode() + this.getAgentPort();
    }
}

