/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.appdef.shared;

public final class AppdefEntityConstants {
    public static final String HQ_AGENT_PROTOTYPE_NAME = "HQ Agent";
    public static final int APPDEF_TYPE_PRIVATEGROUP = 0;
    public static final int APPDEF_TYPE_PLATFORM = 1;
    public static final int APPDEF_TYPE_SERVER = 2;
    public static final int APPDEF_TYPE_SERVICE = 3;
    public static final int APPDEF_TYPE_APPLICATION = 4;
    public static final int APPDEF_TYPE_GROUP = 5;
    public static final int APPDEF_TYPE_AIPLATFORM = 6;
    public static final int APPDEF_TYPE_AISERVER = 7;
    public static final int APPDEF_TYPE_AIIP = 8;
    public static final int APPDEF_TYPE_AUTOGROUP = 9;
    public static final int APPDEF_TYPE_POLICY = 10;
    private static final String APPDEF_NAME_PRIVATEGROUP = "privateGroup";
    private static final String APPDEF_NAME_PLATFORM = "platform";
    private static final String APPDEF_NAME_SERVER = "server";
    private static final String APPDEF_NAME_SERVICE = "service";
    private static final String APPDEF_NAME_APPLICATION = "application";
    private static final String APPDEF_NAME_GROUP = "group";
    private static final String APPDEF_NAME_AIPLATFORM = "aiplatform";
    private static final String APPDEF_NAME_AISERVER = "aiserver";
    private static final String APPDEF_NAME_AIIP = "aiip";
    private static final String APPDEF_NAME_AUTOGROUP = "autogroup";
    private static final String APPDEF_NAME_POLICY = "policy";
    public static final String GENERIC_APPLICATION_TYPE = "Generic Application";
    public static final int RESTREE_TRAVERSE_NORMAL = 1;
    public static final int RESTREE_TRAVERSE_UP = 2;
    public static final int APPDEF_TYPE_GROUP_ADHOC_APP = 11;
    public static final int APPDEF_TYPE_GROUP_ADHOC_GRP = 12;
    public static final int APPDEF_TYPE_GROUP_ADHOC_PSS = 13;
    public static final int APPDEF_TYPE_GROUP_COMPAT_PS = 14;
    public static final int APPDEF_TYPE_GROUP_COMPAT_SVC = 15;
    public static final int APPDEF_TYPE_GROUP_DYNAMIC = 16;
    public static final int APPDEF_TYPE_GROUP_POLICY = 17;
    private static final String APPDEF_TYPE_GROUP_ADHOC_APP_LABEL = "Mixed Group - Applications";
    private static final String APPDEF_TYPE_GROUP_ADHOC_GRP_LABEL = "Mixed Group - Groups";
    private static final String APPDEF_TYPE_GROUP_ADHOC_PSS_LABEL = "Mixed Group - Platforms,Servers & Services";
    private static final String APPDEF_TYPE_GROUP_COMPAT_PS_LABEL = "Compatible / Cluster Group";
    private static final String APPDEF_TYPE_GROUP_COMPAT_SVC_LABEL = "Compatible Group - Service Cluster";
    private static final String APPDEF_TYPE_GROUP_DYNAMIC_LABEL = "Dynamic Group";

    public static int[] getAppdefTypes() {
        return new int[]{1, 2, 3, 4, 5};
    }

    public static int[] getAppdefGroupTypes() {
        return new int[]{11, 12, 13, 14, 15};
    }

    public static int[] getAppdefGroupTypesNormalized() {
        return new int[]{11, 12, 13, 15};
    }

    public static String typeToString(int type) {
        switch (type) {
            case 1: {
                return APPDEF_NAME_PLATFORM;
            }
            case 2: {
                return APPDEF_NAME_SERVER;
            }
            case 3: {
                return APPDEF_NAME_SERVICE;
            }
            case 4: {
                return APPDEF_NAME_APPLICATION;
            }
            case 5: {
                return APPDEF_NAME_GROUP;
            }
            case 6: {
                return APPDEF_NAME_AIPLATFORM;
            }
            case 7: {
                return APPDEF_NAME_AISERVER;
            }
            case 8: {
                return APPDEF_NAME_AIIP;
            }
            case 9: {
                return APPDEF_NAME_AUTOGROUP;
            }
        }
        throw new IllegalArgumentException("Unknown appdef type: " + type);
    }

    public static int stringToType(String name) {
        if (name.equals(APPDEF_NAME_PLATFORM)) {
            return 1;
        }
        if (name.equals(APPDEF_NAME_SERVER)) {
            return 2;
        }
        if (name.equals(APPDEF_NAME_SERVICE)) {
            return 3;
        }
        if (name.equals(APPDEF_NAME_APPLICATION)) {
            return 4;
        }
        if (name.equals(APPDEF_NAME_GROUP)) {
            return 5;
        }
        if (name.equals(APPDEF_NAME_AIPLATFORM)) {
            return 6;
        }
        if (name.equals(APPDEF_NAME_AISERVER)) {
            return 7;
        }
        if (name.equals(APPDEF_NAME_AIIP)) {
            return 8;
        }
        throw new IllegalArgumentException("Unknown appdef type: " + name);
    }

    public static boolean typeIsValid(int type) {
        return type >= 1 && type <= 10;
    }

    public static boolean groupTypeIsValid(int type) {
        return type >= 11 && type <= 15;
    }

    public static String getAppdefGroupTypeName(int grpType) {
        switch (grpType) {
            case 11: {
                return APPDEF_TYPE_GROUP_ADHOC_APP_LABEL;
            }
            case 12: {
                return APPDEF_TYPE_GROUP_ADHOC_GRP_LABEL;
            }
            case 13: {
                return APPDEF_TYPE_GROUP_ADHOC_PSS_LABEL;
            }
            case 14: {
                return APPDEF_TYPE_GROUP_COMPAT_PS_LABEL;
            }
            case 15: {
                return APPDEF_TYPE_GROUP_COMPAT_SVC_LABEL;
            }
            case 16: {
                return APPDEF_TYPE_GROUP_DYNAMIC_LABEL;
            }
            case 0: {
                return APPDEF_NAME_PRIVATEGROUP;
            }
        }
        throw new IllegalArgumentException("Unknown appdef group type: " + grpType);
    }

    public static boolean isGroupAdhoc(int grpType) {
        return grpType == 11 || grpType == 12 || grpType == 13;
    }

    public static boolean isGroupCompat(int grpType) {
        return grpType == 14 || grpType == 15;
    }

    public static boolean isDynamicGroup(int grpType) {
        return grpType == 16;
    }
}

