/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.commands;

import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;

public class GetMeasurements_args
extends AgentRemoteValue {
    private static final String PARAM_DSN = "dsn";
    private static final String PARAM_NMEAS = "nmeas";

    private void setup() {
        this.setNumMeasurements(0);
    }

    public GetMeasurements_args() {
        this.setup();
    }

    public GetMeasurements_args(AgentRemoteValue args) throws AgentRemoteException {
        this.setup();
        int nmeas = args.getValueAsInt(PARAM_NMEAS);
        for (int i = 0; i < nmeas; ++i) {
            String metric = args.getValue(PARAM_DSN + i);
            this.addMeasurement(metric);
        }
    }

    public int getNumMeasurements() {
        try {
            return this.getValueAsInt(PARAM_NMEAS);
        }
        catch (AgentRemoteException exc) {
            throw new AgentAssertionException("This should never occur");
        }
    }

    private void setNumMeasurements(int newMeas) {
        super.setValue(PARAM_NMEAS, Integer.toString(newMeas));
    }

    public void addMeasurement(String metric) {
        int curMeas = this.getNumMeasurements();
        super.setValue(PARAM_DSN + curMeas, metric);
        this.setNumMeasurements(curMeas + 1);
    }

    public void setValue(String key, String val) {
        throw new AgentAssertionException("This should never be called");
    }

    public String getMeasurement(int measNum) {
        String qval = PARAM_DSN + measNum;
        return this.getValue(qval);
    }
}

