/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.stats;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.stats.AbstractStatsCollector;
import org.hyperic.util.stats.StatCollector;
import org.hyperic.util.stats.StatUnreachableException;
import org.hyperic.util.stats.StatsObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStatsWriter {
    private static final Log log = LogFactory.getLog(AbstractStatsWriter.class);
    private final AbstractStatsCollector statsCollector;
    private final Retention retentionType;
    private String currFilename;
    private FileWriter file;
    private String basedir;
    private String filePrefix;
    public static final int WRITE_PERIOD = 15;

    public AbstractStatsWriter(AbstractStatsCollector statsCollector, Retention retentionType, String filePrefix) {
        this.statsCollector = statsCollector;
        this.retentionType = retentionType;
        this.filePrefix = filePrefix;
    }

    public void startWriter() {
        this.basedir = this.getAndSetupBasedir();
        this.setFileInfo();
        this.printHeader();
        this.scheduleWithFixedDelay(new StatsWriter(), new Date(this.now() + 15000L), 15000L);
        this.statsCollector.setStarted(true);
        log.info((Object)"StatsCollector has started");
    }

    protected abstract ScheduledFuture<?> scheduleWithFixedDelay(Runnable var1, Date var2, long var3);

    protected abstract String getAndSetupBasedir();

    private void setFileInfo() {
        this.currFilename = this.getFilename(false);
        this.cleanupFilename(this.currFilename);
        File aFile = new File(this.currFilename);
        try {
            if (aFile.exists()) {
                String mvFilename = this.getFilename(true);
                aFile.renameTo(new File(mvFilename));
                AbstractStatsWriter.gzipFile(mvFilename);
            }
            if (this.file != null) {
                this.file.close();
            }
            this.file = new FileWriter(this.currFilename, true);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private final void cleanupFilename(String filename) {
        File file = new File(filename);
        final File path = file.getParentFile();
        final String name = file.getName();
        FilenameFilter filter = new FilenameFilter(){
            final String _filename;
            {
                this._filename = name;
            }

            public boolean accept(File dir, String name2) {
                return dir.equals(path) && name2.startsWith(this._filename);
            }
        };
        File[] files = path.listFiles(filter);
        long oneWeekAgo = System.currentTimeMillis() - 604800000L;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].lastModified() >= oneWeekAgo) continue;
            files[i].delete();
        }
    }

    private final void printHeader() {
        StringBuilder buf = new StringBuilder("timestamp,");
        String countAppend = "_COUNT";
        for (Map.Entry<String, StatCollector> entry : this.statsCollector.getStatKeys().entrySet()) {
            String key = entry.getKey();
            StatCollector value = entry.getValue();
            buf.append(key).append(',');
            if (value != null) continue;
            buf.append(key).append("_COUNT").append(',');
        }
        try {
            this.file.append(buf.append("\n").toString());
            this.file.flush();
        }
        catch (IOException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private final String getFilename(boolean withTimestamp) {
        Calendar cal = Calendar.getInstance();
        int month = 1 + cal.get(2);
        String monthStr = month < 10 ? "0" + month : String.valueOf(month);
        int day = cal.get(5);
        String dayStr = day < 10 ? "0" + day : String.valueOf(day);
        String rtn = null;
        rtn = this.retentionType == Retention.YEARLY ? this.filePrefix + "-" + monthStr + "-" + dayStr : this.filePrefix + "-" + dayStr;
        if (withTimestamp) {
            int hour = cal.get(11);
            String hourStr = hour < 10 ? "0" + hour : String.valueOf(hour);
            int min = cal.get(12);
            String minStr = min < 10 ? "0" + min : String.valueOf(min);
            int sec = cal.get(13);
            String secStr = sec < 10 ? "0" + sec : String.valueOf(sec);
            rtn = rtn + "-" + hourStr + "." + minStr + "." + secStr;
        }
        String fs = File.separator;
        return this.basedir + fs + rtn + ".csv";
    }

    public static void gzipFile(final String filename) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block9: {
                    block8: {
                        FileOutputStream gfile = null;
                        GZIPOutputStream gstream = null;
                        PrintStream pstream = null;
                        BufferedReader reader = null;
                        boolean succeed = false;
                        try {
                            String tmp;
                            gfile = new FileOutputStream(filename + ".gz");
                            gstream = new GZIPOutputStream(gfile);
                            pstream = new PrintStream(gstream);
                            reader = new BufferedReader(new FileReader(filename));
                            while (null != (tmp = reader.readLine())) {
                                pstream.append(tmp).append("\n");
                            }
                            gstream.finish();
                            succeed = true;
                            this.close(gfile);
                            this.close(gstream);
                            this.close(pstream);
                            this.close(reader);
                            if (!succeed) break block8;
                            new File(filename).delete();
                        }
                        catch (IOException e) {
                            log.warn((Object)e.getMessage(), (Throwable)e);
                            break block9;
                        }
                        finally {
                            this.close(gfile);
                            this.close(gstream);
                            this.close(pstream);
                            this.close(reader);
                            if (succeed) {
                                new File(filename).delete();
                            } else {
                                new File(filename + ".gz").delete();
                            }
                        }
                        break block9;
                    }
                    new File(filename + ".gz").delete();
                }
            }

            private void close(Closeable s) {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }.start();
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatsWriter
    implements Runnable {
        private StatsWriter() {
        }

        @Override
        public synchronized void run() {
            try {
                Map<String, List<Number>> stats = this.getStatsByKey();
                StringBuilder buf = this.getCSVBuf(stats);
                FileWriter fw = this.getFileWriter();
                fw.append(buf.append("\n").toString());
                fw.flush();
            }
            catch (Throwable e) {
                log.warn((Object)e.getMessage(), e);
            }
        }

        private FileWriter getFileWriter() throws IOException {
            String filename = AbstractStatsWriter.this.getFilename(false);
            if (!AbstractStatsWriter.this.currFilename.equals(filename)) {
                AbstractStatsWriter.this.file.close();
                AbstractStatsWriter.gzipFile(AbstractStatsWriter.this.currFilename);
                AbstractStatsWriter.this.file = new FileWriter(filename, true);
                AbstractStatsWriter.this.printHeader();
                AbstractStatsWriter.this.currFilename = filename;
                AbstractStatsWriter.this.cleanupFilename(AbstractStatsWriter.this.currFilename);
            }
            return AbstractStatsWriter.this.file;
        }

        private final StringBuilder getCSVBuf(Map<String, List<Number>> stats) {
            StringBuilder rtn = new StringBuilder();
            rtn.append(System.currentTimeMillis()).append(',');
            for (Map.Entry<String, StatCollector> entry : AbstractStatsWriter.this.statsCollector.getStatKeys().entrySet()) {
                String key = entry.getKey();
                StatCollector stat = entry.getValue();
                if (stat != null) {
                    try {
                        long value = stat.getVal();
                        rtn.append(value).append(',');
                    }
                    catch (StatUnreachableException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)e.getMessage(), (Throwable)e);
                        }
                        rtn.append(',');
                    }
                    continue;
                }
                List<Number> list = stats.get(key);
                long total = 0L;
                if (list != null) {
                    for (Number val : list) {
                        total += val.longValue();
                    }
                    rtn.append(total).append(',').append(list.size()).append(",");
                    continue;
                }
                rtn.append(',').append(',');
            }
            return rtn;
        }

        private Map<String, List<Number>> getStatsByKey() {
            StatsObject stat;
            String id;
            StatsObject obj;
            HashMap<String, List<Number>> rtn = new HashMap<String, List<Number>>();
            StatsObject marker = AbstractStatsWriter.this.statsCollector.generateMarker();
            while (marker != (obj = AbstractStatsWriter.this.statsCollector.pollQueue()) && (id = (stat = obj).getId()) != null) {
                Long val = stat.getVal();
                ArrayList<Long> tmp = (ArrayList<Long>)rtn.get(id);
                if (null == tmp) {
                    tmp = new ArrayList<Long>();
                    rtn.put(id, tmp);
                }
                tmp.add(new Long(val));
            }
            return rtn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Retention {
        MONTHLY,
        YEARLY;

    }
}

