/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.hyperic.tools.db.DBSetup;
import org.hyperic.util.StringList;
import org.hyperic.util.StrongCollection;
import org.hyperic.util.jdbc.JDBC;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class View {
    private DBSetup _parent;
    private String _strName;
    private String _strQuery;

    protected View(Node node, int dbtype, DBSetup dbsetup) throws SAXException {
        this._parent = dbsetup;
        boolean queryIsSet = false;
        if (View.isView(node)) {
            NamedNodeMap map = node.getAttributes();
            for (int iTab = 0; iTab < map.getLength(); ++iTab) {
                Node nodeMap = map.item(iTab);
                if (nodeMap.getNodeName().equalsIgnoreCase("name")) {
                    this._strName = nodeMap.getNodeValue();
                    continue;
                }
                if (!this._parent.isVerbose()) continue;
                System.out.println("Unknown attribute '" + nodeMap.getNodeName() + "' in tag 'table'");
            }
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (!child.getNodeName().equalsIgnoreCase("query") || !child.hasChildNodes()) continue;
                NodeList contentNodes = child.getChildNodes();
                this._strQuery = child.getFirstChild().getNodeValue();
                queryIsSet = true;
            }
            if (!queryIsSet) {
                throw new SAXException("no query specified");
            }
        } else {
            throw new SAXException("node is not a table.");
        }
    }

    protected void create(Collection typemaps) throws SQLException {
        Vector commands = new Vector();
        this.getCreateCommands(commands, typemaps, JDBC.toType((String)this._parent.getConn().getMetaData().getURL()));
        for (String strCmd : commands) {
            this._parent.doSQL(strCmd);
        }
    }

    private void doCmd(List collCmds) throws SQLException {
        for (String strCmd : collCmds) {
            this._parent.doSQL(strCmd);
        }
    }

    protected void drop() throws SQLException {
        StringList collCmds = new StringList();
        this.getDropCommands((List)collCmds);
        this.doCmd((List)collCmds);
    }

    protected void getCreateCommands(List cmds, Collection typemaps, int dbtype) {
        String strCmd = "CREATE VIEW " + this.getName() + " AS " + this.getQuery();
        cmds.add(0, strCmd);
    }

    protected void getDropCommands(List cmds) {
        String strCmd = "DROP VIEW " + this.getName();
        cmds.add(strCmd);
    }

    protected String getQueryCommand() {
        String strCmd = "SELECT * ";
        strCmd = strCmd + "FROM " + this.getName();
        return strCmd;
    }

    protected String getName() {
        return this._strName.toUpperCase();
    }

    protected String getQuery() {
        return this._strQuery;
    }

    protected static Collection getViews(Node node, int dbtype, DBSetup parent) {
        StrongCollection colResult = new StrongCollection("org.hyperic.tools.db.View");
        NodeList listViews = node.getChildNodes();
        for (int i = 0; i < listViews.getLength(); ++i) {
            Node nodeView = listViews.item(i);
            if (!View.isView(nodeView)) continue;
            try {
                colResult.add(new View(nodeView, dbtype, parent));
                continue;
            }
            catch (SAXException e) {
                // empty catch block
            }
        }
        return colResult;
    }

    protected static boolean isView(Node nodeTable) {
        return nodeTable.getNodeName().equalsIgnoreCase("view");
    }

    protected DBSetup getDBSetup() {
        return this._parent;
    }

    protected static void uninstallCleanup(DBSetup parent) throws SQLException {
    }
}

